/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.dao;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author sistem17user
 */
public interface UsuarioDAO {

	public JSONArray listarUsuario(JSONObject datos, int vstart, int vlength, int draw) throws Exception;

	public int cantidadRegistros(JSONObject datos) throws Exception;

	public int editarUsuario(int codigo, String usuario, String clave) throws Exception;

	public int activarUsuario(int codigo) throws Exception;

	public int desactivarUsuario(int codigo) throws Exception;

	public int crearUsuario(String codigoTrabajador, String usuario, String clave) throws Exception;

	public int validarUsuario(String codigoTrabajador) throws Exception;

	public int eliminarUsuario(int codigo) throws Exception;

	public JSONObject listarUsuarioDetalle(String filtro, int vstart, int vlength, String draw) throws Exception;

	public int eliminarUsuarioDetalle(int codigo) throws Exception;

	public int activarUsuarioDetalle(int codigo) throws Exception;

	public int desactivarUsuarioDetalle(int codigo) throws Exception;

	public int asignarProyectoUsuario(int usuario, int proyectoDetalle) throws Exception;

	public JSONArray listarProyecto() throws Exception;

	public JSONArray listarTipoDeUsuario(int proyecto, int usuario) throws Exception;

	public int validarUsuarioDependencia(int codigo) throws Exception;

	public int validarNombreUsuario(String nombre) throws Exception;

	public int validarAsignacion(int codigo) throws Exception;

	public JSONObject listarUsuarioManual(JSONObject datos) throws Exception;
}
