/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package moduloSeguridad.dao;

import moduloSeguridad.sqlserverdao.SqlServerDAOFactory;

/**
 *
 * @author sistem17user
 */
public abstract class DAOFactory {

	public static final int SQLSERVER = 1;
	public static final int MYSQL = 2;

	public static DAOFactory getDAOFactory(int Motor_Base) {
		switch (Motor_Base) {
			case SQLSERVER:
				return new SqlServerDAOFactory();
			default:
				return null;
		}
	}

	public abstract TipoUsuarioDAO getTipoUsuario();

	public abstract ProyectoDAO getProyectoDAO();

	public abstract UsuarioDAO getUsuarioDAO();

	public abstract MenuDAO getMenuDAO();
}
