package pe.so.api.formulario.services;

import org.json.JSONObject;
import pe.so.api.formulario.dao.ExcelDAO;
import pe.so.api.formulario.dao.FactoryDAO;

import java.util.Objects;
import org.json.JSONArray;

public class ExcelServices{

    ExcelDAO dao = Objects.requireNonNull(FactoryDAO.getFactoryDAO(FactoryDAO.POSTGRESQL)).getExcelDAO();
    public JSONObject execute_encuesta(JSONObject json) throws Exception{
        return dao.execute_encuesta(json);
    }

    public JSONObject execute_balotario(JSONObject json) throws Exception{
        return dao.execute_balotario(json);
    }

    public JSONObject ejecutar(JSONObject json) throws Exception{
        return dao.ejecutar(json);
    }

    public JSONObject execute_avance(JSONObject json) throws Exception{
        return dao.execute_avance(json);
    }

    public JSONObject execute_redes(JSONObject json) throws Exception{
        return dao.execute_redes(json);
    }

    public JSONObject execute_VU(JSONObject json) throws Exception{
        return dao.execute_VU(json);
    }

    public JSONObject execute_reporte_sedes(JSONObject json) throws Exception{
        return dao.execute_reporte_sedes(json);
    }

    public JSONObject execute_reporte_correos(JSONObject json) throws Exception{
        return dao.execute_reporte_correos(json);
    }

    public JSONObject execute_avance_encuesta(JSONObject json) throws Exception{
        return dao.execute_avance_encuesta(json);
    }

    public JSONObject execute_reporte_franquicias(JSONObject json) throws Exception{
        return dao.execute_reporte_franquicia(json);
    }

    public JSONObject execute_matricula_online2(JSONObject json) throws Exception{
        return dao.execute_matricula_online2(json);
    }

    public JSONObject execute_reporte_pagos(JSONObject entrada) throws  Exception{
        return dao.execute_reporte_pagos(entrada);
    }
    
    public JSONObject actualizar_examen_alumno(JSONObject entrada) throws Exception{
        JSONArray params = new JSONArray();

        params.put(0, entrada.getString("drive_respuesta"));
        
        params.put(1, entrada.getString("fecha_registro"));

        params.put(2, entrada.getInt("fila_drive"));

        params.put(3, entrada.getString("correo_alumno"));

        params.put(4, entrada.getString("nota"));

        params.put(5, entrada.getString("apellidos"));

        params.put(6, entrada.getString("nombres"));

        params.put(7, entrada.getString("sede"));

        entrada.put("params", params);

        return dao.actualizar_examen_alumno(entrada);
    }
    
    public JSONObject listar_examen(JSONObject entrada) throws Exception{
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }
        
        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("capitulo_id")) {
            params.put(2, entrada.getInt("capitulo_id"));
        }

        if (!entrada.isNull("grado_turno_id")) {
            params.put(3, entrada.getString("grado_turno_id"));
        }

        if (!entrada.isNull("curso_id")) {
            params.put(4, entrada.getInt("curso_id"));
        }

        if (!entrada.isNull("dia")) {
            params.put(5, entrada.getInt("dia"));
        }

        if (!entrada.isNull("estado_id")) {
            params.put(6, entrada.getInt("estado_id"));
        }

        if (!entrada.isNull("enlazado")) {
            params.put(7, entrada.getBoolean("enlazado"));
        }

        if (!entrada.isNull("sede_id")) {
            params.put(8, entrada.getInt("sede_id"));
        }

        if (!entrada.isNull("aula_id")) {
            params.put(9, entrada.getInt("aula_id"));
        }

        entrada.put("params", params);

        return dao.listar_examen(entrada);
    }
    
    public JSONObject actualizar_examen(JSONObject entrada) throws Exception{
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }
        
        params.put(1, entrada.getString("tipo_operacion"));
        
        if (!entrada.isNull("examen_id")) {
            params.put(2, entrada.getInt("examen_id"));
        }
        
        if (!entrada.isNull("capitulo_id")) {
            params.put(3, entrada.getInt("capitulo_id"));
        }
        
        if (!entrada.isNull("url_publicado")) {
            params.put(4, entrada.getString("url_publicado"));
        }
        
        if (!entrada.isNull("url_edicion")) {
            params.put(5, entrada.getString("url_edicion"));
        }
        
        if (!entrada.isNull("url_respuesta")) {
            params.put(6, entrada.getString("url_respuesta"));
        }
        
        if (!entrada.isNull("estado_id")) {
            params.put(7, entrada.getInt("estado_id"));
        }
        
        if (!entrada.isNull("lista_examen")) {
            params.put(8, entrada.getJSONArray("lista_examen"));
        }

        entrada.put("params", params);

        return dao.actualizar_examen(entrada);
    }
    
}
