package pe.so.api.formulario.postgresdao;

import org.json.JSONObject;
import pe.so.api.formulario.dao.ExcelDAO;
import pe.so.api.formulario.dao.FactoryDAO;
import pe.so.api.formulario.dao.TablasDAO;
import pe.so.api.formulario.utilities.OsUtils;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.DriverManager;
import org.json.JSONArray;
import org.json.JSONException;


import static pe.so.api.formulario.utilities.Config.getConfig;

public class PostgreSqlFactoryDAO extends FactoryDAO{

    static {
        try {
            Class.forName("org.postgresql.Driver");
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static Connection obtenerConexion(String base) {
        Connection conexion = null;
        JSONObject dbConfig = new JSONObject();
        OsUtils.OSType ostype = OsUtils.getOperatingSystemType();
        switch (ostype) {
            case Windows:
                dbConfig = getConfig("C:/dotenv/formularios-api/config.json", "db_config", base);
                break;
            case Linux:
            case MacOS:
                dbConfig = getConfig("/opt/dotenv/formularios-api/config.json", "db_config", base);
                break;
            case Other:
                break;
        }
        try {
            conexion = DriverManager.getConnection(
                    "jdbc:postgresql://" + dbConfig.getString("host") + ":" + dbConfig.getString("port") + "/" + dbConfig.getString("db_name") + "",
                    dbConfig.getString("user"),
                    dbConfig.getString("password"));
        } catch (SQLException | JSONException e) {
            e.printStackTrace();
        }
        return conexion;
    }
    
    //Store procedure
    public static JSONArray queryProcedure(String base, String sql, JSONArray... parametros) throws Exception {
        return queryProcedure(obtenerConexion(base), sql, false, parametros);
    }

    public static JSONObject queryPSSingle(String base, String sql, JSONArray... parametros) throws Exception {
        return queryPSSingle(obtenerConexion(base), sql, false, parametros);
    }

    public static JSONObject queryJSONObject(String base, String sql, JSONObject data) throws Exception {
        return queryJSONObject(obtenerConexion(base), sql, data);
    }

    @Override
    public ExcelDAO getExcelDAO(){
        return new PostgreSqlExcel();
    }
    public TablasDAO getTablasDAO(){
        return new PostgreSqlTabla();

    }
}
