package pe.so.api.formulario.postgresdao;

import org.json.JSONArray;
import org.json.JSONObject;
import pe.so.api.formulario.dao.ExcelDAO;

import java.sql.*;
import java.util.Date;

public class PostgreSqlExcel implements ExcelDAO {

    @Override
    public JSONObject execute_encuesta(JSONObject json) throws Exception {
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;

        try {

            int p_encuensta_id = json.isNull("p_encuesta_id") ? 0 : json.getInt("p_encuesta_id");
            String p_grupo_encuesta = json.isNull("p_grupo_encuesta") ? "" : json.getString("p_grupo_encuesta");
            String p_correo_alumno = json.isNull("p_correo_alumno") ? "" : json.getString("p_correo_alumno");
            String p_documento = json.isNull("p_documento") ? "" : json.getString("p_documento");
            String p_nombres = json.isNull("p_nombres") ? "" : json.getString("p_nombres");

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "select horario.func_encuesta_procesar_alumno(?,?,?,?,?)";
            PreparedStatement ps = conexion.prepareStatement(sql);
            ps.setInt(1, p_encuensta_id);
            ps.setString(2, p_grupo_encuesta);
            ps.setString(3, p_correo_alumno);
            ps.setString(4, p_documento);
            ps.setString(5, p_nombres);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }
            respuesta.put("status", true);

        } catch (Exception e) {
            respuesta.put("status", false);
            respuesta.put("mensaje", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }
        return respuesta;
    }

    @Override
    public JSONObject execute_balotario(JSONObject json) throws Exception {
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;

        try {

            String p_drive_respuesta = json.isNull("p_drive_respuesta") ? "" : json.getString("p_drive_respuesta");
            String p_fecha_registro = json.isNull("p_fecha_registro") ? "" : json.getString("p_fecha_registro");
            int p_fila_drive = json.isNull("p_fila_drive") ? 0 : json.getInt("p_fila_drive");
            String p_correo_alumno = json.isNull("p_correo_alumno") ? "" : json.getString("p_correo_alumno");
            String p_nota = json.isNull("p_nota") ? "" : json.getString("p_nota");
            String p_apellidos = json.isNull("p_apellidos") ? "" : json.getString("p_apellidos");
            String p_nombres = json.isNull("p_nombres") ? "" : json.getString("p_nombres");
            String p_sede = json.isNull("p_sede") ? "" : json.getString("p_sede");

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "select academico.func_balotario_procesar_alumno(?,?,?,?,?,?,?,?)";
            PreparedStatement ps = conexion.prepareStatement(sql);
            ps.setString(1, p_drive_respuesta);
            ps.setString(2, p_fecha_registro);
            ps.setInt(3, p_fila_drive);
            ps.setString(4, p_correo_alumno);
            ps.setString(5, p_nota);
            ps.setString(6, p_apellidos);
            ps.setString(7, p_nombres);
            ps.setString(8, p_sede);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put("mensaje", rs.getObject(i));
                }
            }
            respuesta.put("status", true);

        } catch (Exception e) {
            respuesta.put("status", false);
            respuesta.put("mensaje", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }
        return respuesta;
    }

    public JSONObject ejecutar(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;

        try {

            Date date = new Date();
            java.sql.Timestamp sqlTime = new java.sql.Timestamp(date.getTime());

            String p_drive_origen = json.getString("p_drive_origen");
            int p_drive_fila = json.getInt("p_drive_fila");
            String p_sede = json.getString("p_sede");
            String p_medio_atencion = json.getString("p_medio_atencion");
            String p_contacto_nombres = json.getString("p_contacto_nombres");
            String p_contacto_apellidos = json.getString("p_contacto_apellidos");
            String p_numero_documento = json.getString("p_numero_documento");
            String p_contacto_correo = json.getString("p_contacto_correo");
            String p_atencion_usuario = json.getString("p_atencion_usuario");
            String p_grado = json.getString("p_grado");
            String p_contacto_telefono = json.getString("p_contacto_telefono");
            String p_colegio_procedencia = json.getString("p_colegio_procedencia");
            String p_distrito = json.getString("p_distrito");
            String p_atencion_fecha = json.getString("p_atencion_fecha");
            String p_atencion_estado = json.getString("p_atencion_estado");
            String p_atencion_medio_atencion = json.getString("p_atencion_medio_atencion");
            String p_atencion_hora = json.getString("p_atencion_hora");
            String p_atencion_observacion = json.getString("p_atencion_observacion");
            String p_medio_difusion_nombre = json.getString("p_medio_difusion_nombre");

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "select matricula.func_informe_registrar(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement ps = conexion.prepareStatement(sql);
            ps.setString(1, p_drive_origen);
            ps.setInt(2, p_drive_fila);
            ps.setString(3, sqlTime.toString());
            ps.setString(4, p_sede);
            ps.setString(5, p_medio_atencion);
            ps.setString(6, p_contacto_nombres);
            ps.setString(7, p_contacto_apellidos);
            ps.setString(8, p_numero_documento);
            ps.setString(9, p_contacto_correo);
            ps.setString(10, p_contacto_telefono);
            ps.setString(11, p_distrito);
            ps.setString(12, p_grado);
            ps.setString(13, p_colegio_procedencia);
            ps.setString(14, p_medio_difusion_nombre);
            ps.setString(15, p_atencion_usuario);
            ps.setString(16, p_atencion_fecha);
            ps.setString(17, p_atencion_estado);
            ps.setString(18, p_atencion_medio_atencion);
            ps.setString(19, p_atencion_hora);
            ps.setString(20, p_atencion_observacion);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }

                respuesta.put("status", respuesta.getString("func_informe_registrar").contains("_informe_id"));

            }

        } catch (Exception e) {
            respuesta.put("status", false);
            respuesta.put("mensaje", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }
        return respuesta;
    }

    @Override
    public JSONObject execute_avance(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;

        try {

            int p_tipo_operacion = json.getInt("p_tipo_operacion");
            int p_aula_id = json.isNull("p_aula_id") ? 0 : json.getInt("p_aula_id");
            int p_curso_id = json.isNull("p_curso_id") ? 0 : json.getInt("p_curso_id");

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "select academico.func_balotario_alumno(?,?,?)";
            PreparedStatement ps = conexion.prepareStatement(sql);
            Statement st = conexion.createStatement();
            ps.setInt(1, p_tipo_operacion);
            ps.setInt(2, p_aula_id);
            ps.setInt(3, p_curso_id);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();

                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), new JSONObject(rs.getObject(i).toString()));
                }
            }

            JSONArray data = respuesta.getJSONObject("func_balotario_alumno").getJSONArray("data");
            JSONArray respuesta2 = new JSONArray();
            data.forEach(item -> {
                JSONObject obj = (JSONObject) item;
                String sql2 = obj.getString("script");
                try {
                    st.executeQuery(sql2);
                } catch (SQLException ignored) {
                }
            });

            respuesta.put("salida", respuesta2);

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_redes(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;

        try {
            String p_tipo_vista = json.getString("p_tipo_vista");
            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "SELECT * FROM matricula.func_redes_sociales(?)";

            PreparedStatement ps = conexion.prepareStatement(sql);
            ps.setString(1, p_tipo_vista);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_VU(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "SELECT * FROM matricula.func_reporte_general_vacacional()";
            ResultSet rs = conexion.prepareStatement(sql).executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_reporte_sedes(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "select * from matricula.func_reporte_general_matricula()";
            ResultSet rs = conexion.prepareStatement(sql).executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_reporte_correos(JSONObject json) throws Exception {
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "select * from matricula.func_reporte_general_correos()";
            ResultSet rs = conexion.prepareStatement(sql).executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_avance_encuesta(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        try {
            int p_opt = json.getInt("p_opt");

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "select academico.func_encuesta_total(?)";
            PreparedStatement ps = conexion.prepareStatement(sql);
            Statement st = conexion.createStatement();
            ps.setInt(1, p_opt);

            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();

                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), new JSONObject(rs.getObject(i).toString()));
                }
            }

            JSONArray data = respuesta.getJSONObject("func_encuesta_total").getJSONArray("data");
            JSONArray respuesta2 = new JSONArray();
            data.forEach(item -> {
                JSONObject obj = (JSONObject) item;
                String sql2 = obj.getString("script");
                try {
                    st.executeQuery(sql2);
                } catch (SQLException ignored) {
                }
            });

            respuesta.put("salida", respuesta2);

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    public JSONObject execute_reporte_franquicia(JSONObject json) throws Exception {
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "select * from matricula.func_reporte_general_franquicia();";
            ResultSet rs = conexion.prepareStatement(sql).executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    public JSONObject execute_matricula_online2(JSONObject json) throws Exception {

        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "select * from matricula.func_registrar_matricula_academia_online2(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
            PreparedStatement ps = conexion.prepareStatement(sql);

            if (json.isNull("p_alumno_es_menor")) {
                ps.setNull(1, Types.VARCHAR);
            } else {
                ps.setString(1, json.getString("p_alumno_es_menor"));
            }

            if (json.isNull("p_alumno_tipo_documento_id")) {
                ps.setNull(2, Types.INTEGER);
            } else {
                ps.setInt(2, json.getInt("p_alumno_tipo_documento_id"));
            }

            if (json.isNull("p_alumno_numero_documento")) {
                ps.setNull(3, Types.VARCHAR);
            } else {
                ps.setString(3, json.getString("p_alumno_numero_documento"));
            }

            if (json.isNull("p_alumno_apellido_paterno")) {
                ps.setNull(4, Types.VARCHAR);
            } else {
                ps.setString(4, json.getString("p_alumno_apellido_paterno"));
            }

            if (json.isNull("p_alumno_apellido_materno")) {
                ps.setNull(5, Types.VARCHAR);
            } else {
                ps.setString(5, json.getString("p_alumno_apellido_materno"));
            }

            if (json.isNull("p_alumno_nombre")) {
                ps.setNull(6, Types.VARCHAR);
            } else {
                ps.setString(6, json.getString("p_alumno_nombre"));
            }

            if (json.isNull("p_alumno_departamento_residencia_id")) {
                ps.setNull(7, Types.INTEGER);
            } else {
                ps.setInt(7, json.getInt("p_alumno_departamento_residencia_id"));
            }

            if (json.isNull("p_alumno_provincia_residencia_id")) {
                ps.setNull(8, Types.INTEGER);
            } else {
                ps.setInt(8, json.getInt("p_alumno_provincia_residencia_id"));
            }

            if (json.isNull("p_alumno_distrito_residencia_id")) {
                ps.setNull(9, Types.INTEGER);
            } else {
                ps.setInt(9, json.getInt("p_alumno_distrito_residencia_id"));
            }

            if (json.isNull("p_apoderado_tipo_documento_id")) {
                ps.setNull(10, Types.INTEGER);
            } else {
                ps.setInt(10, json.getInt("p_apoderado_tipo_documento_id"));
            }

            if (json.isNull("p_apoderado_numero_documento")) {
                ps.setNull(11, Types.VARCHAR);
            } else {
                ps.setString(11, json.getString("p_apoderado_numero_documento"));
            }

            if (json.isNull("p_apoderado_apellido_paterno")) {
                ps.setNull(12, Types.VARCHAR);
            } else {
                ps.setString(12, json.getString("p_apoderado_apellido_paterno"));
            }

            if (json.isNull("p_apoderado_apellido_materno")) {
                ps.setNull(13, Types.VARCHAR);
            } else {
                ps.setString(13, json.getString("p_apoderado_apellido_materno"));
            }

            if (json.isNull("p_apoderado_nombre")) {
                ps.setNull(14, Types.VARCHAR);
            } else {
                ps.setString(14, json.getString("p_apoderado_nombre"));
            }

            if (json.isNull("p_apoderado_parentesco_id")) {
                ps.setNull(15, Types.INTEGER);
            } else {
                ps.setInt(15, json.getInt("p_apoderado_parentesco_id"));
            }

            if (json.isNull("p_contacto_telefono")) {
                ps.setNull(16, Types.VARCHAR);
            } else {
                ps.setString(16, json.getString("p_contacto_telefono"));
            }

            if (json.isNull("p_contacto_correo")) {
                ps.setNull(17, Types.VARCHAR);
            } else {
                ps.setString(17, json.getString("p_contacto_correo"));
            }

            if (json.isNull("p_alumno_ciclo_grado")) {
                ps.setNull(18, Types.VARCHAR);
            } else {
                ps.setString(18, json.getString("p_alumno_ciclo_grado"));
            }

            if (json.isNull("p_alumno_procedencia_id")) {
                ps.setNull(19, Types.INTEGER);
            } else {
                ps.setInt(19, json.getInt("p_alumno_procedencia_id"));
            }

            if (json.isNull("p_voucher_numero_operacion")) {
                ps.setNull(20, Types.VARCHAR);
            } else {
                ps.setString(20, json.getString("p_voucher_numero_operacion"));
            }

            if (json.isNull("p_voucher_fecha_deposito")) {
                ps.setNull(21, Types.VARCHAR);
            } else {
                ps.setString(21, json.getString("p_voucher_fecha_deposito"));
            }

            if (json.isNull("p_voucher_titular_cuenta")) {
                ps.setNull(22, Types.VARCHAR);
            } else {
                ps.setString(22, json.getString("p_voucher_titular_cuenta"));
            }

            if (json.isNull("p_voucher_link")) {
                ps.setNull(23, Types.VARCHAR);
            } else {
                ps.setString(23, json.getString("p_voucher_link"));
            }

            if (json.isNull("p_alumno_usuario_informa")) {
                ps.setNull(24, Types.VARCHAR);
            } else {
                ps.setString(24, json.getString("p_alumno_usuario_informa"));
            }

            if (json.isNull("p_alumno_medio_difusion_id")) {
                ps.setNull(25, Types.INTEGER);
            } else {
                ps.setInt(25, json.getInt("p_alumno_medio_difusion_id"));
            }

            if (json.isNull("p_acceso_id")) {
                ps.setNull(26, Types.INTEGER);
            } else {
                ps.setInt(26, json.getInt("p_acceso_id"));
            }

            if (json.isNull("p_sede_id")) {
                ps.setNull(27, Types.INTEGER);
            } else {
                ps.setInt(27, json.getInt("p_sede_id"));
            }


            ResultSet rs = ps.executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    public JSONObject execute_reporte_pagos(JSONObject json) throws SQLException {
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try {
            String sql = "select * from matricula.func_reporte_general_pago();";
            ResultSet rs = conexion.prepareStatement(sql).executeQuery();

            if (rs.next()) {
                int columnCount = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i), rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error", e.getMessage());
        } finally {
            if (conexion != null) {
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject actualizar_examen_alumno(JSONObject entrada) throws Exception {
        String sql = "SELECT * FROM academico.func_examen_procesar_alumno( ?, ?, ?, ?, ?, ?, ?, ? );";
        JSONObject data = PostgreSqlFactoryDAO.queryPSSingle("siiaa", sql, entrada.getJSONArray("params"));
        return new JSONObject(data.getString("json"));
    }
    
    @Override
    public JSONObject listar_examen(JSONObject entrada) throws Exception {
        String sql = "SELECT * FROM academico.func_examen_listar ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? );";
        JSONObject salida = PostgreSqlFactoryDAO.queryPSSingle("siiaa", sql, entrada.getJSONArray("params"));
        return new JSONObject(salida.getString("json"));
    }
    
    @Override
    public JSONObject actualizar_examen(JSONObject entrada) throws Exception {
        String sql = "SELECT * FROM academico.func_examen_actualizar ( ?, ?, ?, ?, ?, ?, ?, ?, ? :: JSON );";
        JSONObject data = PostgreSqlFactoryDAO.queryPSSingle("siiaa", sql, entrada.getJSONArray("params"));
        return new JSONObject(data.getString("json"));
    }
    
}
