package pe.so.api.formulario.api;

import org.json.JSONObject;
import pe.so.api.formulario.services.ExcelServices;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import pe.so.api.formulario.utilities.Commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

@Provider
@Path("excel")
@Consumes("application/json")
@Produces("application/json")
public class ExcelApi {


    private JSONObject MSJ_RESPUESTA = new JSONObject();

    @POST
    @Path("/encuesta")
    public Response encuesta(String json) throws Exception {

        String[] jsonString = {"p_encuesta_id","p_grupo_encuesta","p_correo_alumno","p_documento","p_nombres"};

        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.execute_encuesta(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }

    @POST
    @Path("/balotario")
    public Response balotario(String json) throws Exception {

        String[] jsonString = {"p_drive_respuesta","p_fila_drive","p_correo_alumno","p_nota","p_apellidos","p_nombres","p_sede","p_fecha_registro"};

        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.execute_balotario(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }


    @POST
    @Path("/ejecutar")
    public Response ejecutar(String json) throws Exception {

         String[] jsonString = {"p_drive_origen", "p_drive_fila", "p_sede", "p_fecha_hora_registro", "p_medio_atencion",
                                "p_contacto_nombres", "p_contacto_apellidos", "p_numero_documento", "p_contacto_correo",
                                "p_contacto_telefono", "p_distrito", "p_grado", "p_colegio_procedencia","p_medio_difusion_nombre",
                                "p_atencion_usuario", "p_atencion_fecha", "p_atencion_estado", "p_atencion_medio_atencion", "p_atencion_hora", "p_atencion_observacion"};


        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.ejecutar(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }

    @POST
    @Path("/ejecutar_avance")
    public Response ejecutar_avance(String json) throws Exception {
    
        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_avance(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
    
    }

    @POST
        @Path("/ejecutar_redes")
    public Response ejecutar_redes(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_redes(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reportevu")
    public Response ejecutar_reportevu(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_VU(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_sedes")
    public Response ejecutar_reporte_sedes(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_sedes(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_correos")
    public Response ejecutar_reporte_correos(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_correos(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_avance_encuestas")
    public Response ejecutar_avance_encuestas(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_avance_encuesta(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_franquicia")
    public Response ejecutar_reporte_franquicia(String json) throws Exception {
        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_franquicias(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
    }

    @POST
    @Path("/ejecutar_matricula_online2")
    public Response ejecutar_matricula_online2(String json) throws Exception {

        String[] jsonString = {"p_alumno_es_menor", "p_alumno_tipo_documento_id", "p_alumno_numero_documento", "p_alumno_apellido_paterno",
                "p_alumno_apellido_materno", "p_alumno_nombre", "p_alumno_departamento_residencia_id", "p_alumno_provincia_residencia_id",
                "p_alumno_distrito_residencia_id", "p_apoderado_tipo_documento_id", "p_apoderado_numero_documento", "p_apoderado_apellido_paterno",
                "p_apoderado_apellido_materno", "p_apoderado_nombre", "p_apoderado_parentesco_id", "p_contacto_telefono", "p_contacto_correo",
                "p_alumno_ciclo_grado", "p_alumno_procedencia_id", "p_voucher_numero_operacion", "p_voucher_fecha_deposito", "p_voucher_titular_cuenta",
                "p_voucher_link", "p_alumno_usuario_informa", "p_alumno_medio_difusion_id", "p_acceso_id", "p_sede_id"};

        JSONObject entrada = new JSONObject(json);

        if(Commons.validarFormato(jsonString,json)){
            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.execute_matricula_online2(entrada);
            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{

            //keys that are not in the jsoNString
            List<String> SALIDA = new ArrayList<String>();
            String[] keys = JSONObject.getNames(entrada);
            for (String jsonkey : jsonString) {
                if(!Arrays.asList(keys).contains(jsonkey)){
                    SALIDA.add(jsonkey);
                }
            }

            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("keys", SALIDA).toString()
            ).build();
        }
    }

    @POST
    @Path("/ejecutar_reporte_pagos")
    public Response ejecutar_reporte_pagos( String json ) throws Exception{
        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_pagos(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
    }
    
    @POST
    @Path("/examen")
    public Response actualizar_examen_alumno(String json) throws Exception {
        JSONObject salida = new JSONObject();

        try {
            JSONObject entrada = new JSONObject(json);

            salida = new ExcelServices().actualizar_examen_alumno(entrada);

            return Response.status(200).entity(salida.toString()).build();
        } catch (JSONException ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(400).entity(salida.toString()).build());
        } catch (BadRequestException ex) {
            salida = new JSONObject(ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        } catch (Exception ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        }
    }
        
    @POST
    @Path("/listar_examen")
    public Response listar_examen(String json) {
        JSONObject salida = new JSONObject();

        try {
            JSONObject entrada = new JSONObject(json);

            salida = new ExcelServices().listar_examen(entrada);

            return Response.status(200).entity(salida.toString()).build();
        } catch (JSONException ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(400).entity(salida.toString()).build());
        } catch (BadRequestException ex) {
            salida = new JSONObject(ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        } catch (Exception ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        }
    }

    @POST
    @Path("/actualizar_examen")
    public Response actualizar_examen(String json) throws Exception {
        JSONObject salida = new JSONObject();

        try {
            JSONObject entrada = new JSONObject(json);

            salida = new ExcelServices().actualizar_examen(entrada);

            return Response.status(200).entity(salida.toString()).build();
        } catch (JSONException ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(400).entity(salida.toString()).build());
        } catch (BadRequestException ex) {
            salida = new JSONObject(ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        } catch (Exception ex) {
            salida.put("status", false);
            salida.put("message", ex.getMessage());
            throw new WebApplicationException(Response.status(500).entity(salida.toString()).build());
        }
    }

}
