package pe.so.api.formulario.services;

import org.json.JSONObject;
import pe.so.api.formulario.dao.ExcelDAO;
import pe.so.api.formulario.dao.FactoryDAO;

import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.postgresql.util.PSQLException;

public class ExcelServices {

    ExcelDAO dao = Objects.requireNonNull(FactoryDAO.getFactoryDAO(FactoryDAO.POSTGRESQL)).getExcelDAO();

    public JSONObject execute_encuesta(JSONObject json) throws Exception {
        return dao.execute_encuesta(json);
    }

    public JSONObject execute_balotario(JSONObject json) throws Exception {
        return dao.execute_balotario(json);
    }

    public JSONObject ejecutar(JSONObject json) throws Exception {
        return dao.ejecutar(json);
    }

    public JSONObject execute_avance(JSONObject json) throws Exception {
        return dao.execute_avance(json);
    }

    public JSONObject execute_redes(JSONObject json) throws Exception {
        return dao.execute_redes(json);
    }

    public JSONObject execute_VU(JSONObject json) throws Exception {
        return dao.execute_VU(json);
    }
    
    public JSONObject execute_reporte_sedes(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        params.put(0, entrada.getString("tipo_operacion"));

        params.put(1, entrada.getInt("periodo_academico_id"));

        entrada.put("params", params);

        return dao.execute_reporte_sedes(entrada);
    }

    public JSONObject execute_reporte_correos(JSONObject json) throws Exception {
        return dao.execute_reporte_correos(json);
    }

    public JSONObject execute_avance_encuesta(JSONObject json) throws Exception {
        return dao.execute_avance_encuesta(json);
    }

    public JSONObject execute_reporte_franquicias(JSONObject json) throws Exception {
        return dao.execute_reporte_franquicia(json);
    }

    public JSONObject execute_matricula_online2(JSONObject json) throws Exception {
        return dao.execute_matricula_online2(json);
    }

    public JSONObject execute_reporte_pagos(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        params.put(0, entrada.getInt("periodo_academico_id"));

        entrada.put("params", params);

        return dao.execute_reporte_pagos(entrada);
    }

    public JSONObject listar_balotario(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("periodo_id")) {
            params.put(3, entrada.getInt("periodo_id"));
        }
        
        if (!entrada.isNull("periodo_academico_id")) {
            params.put(4, entrada.getInt("periodo_academico_id"));
        }

        entrada.put("params", params);

        return dao.listar_balotario(entrada);
    }

    public JSONObject actualizar_balotario(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("periodo_id")) {
            params.put(2, entrada.getInt("periodo_id"));
        }

        entrada.put("params", params);

        return dao.actualizar_balotario(entrada);
    }

    public JSONObject actualizar_balotario_alumno(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        params.put(0, entrada.getString("drive_respuesta"));

        params.put(1, entrada.getString("fecha_registro"));

        params.put(2, entrada.getInt("fila_drive"));

        params.put(3, entrada.getString("correo_alumno"));

        params.put(4, entrada.getString("nota"));

        params.put(5, entrada.getString("apellidos"));

        params.put(6, entrada.getString("nombres"));

        params.put(7, entrada.getString("sede"));

        entrada.put("params", params);

        return dao.actualizar_balotario_alumno(entrada);
    }

    public JSONObject actualizar_balotario_alumno_masivo(JSONObject entrada) throws Exception {
        JSONArray lista_balotario_api = entrada.getJSONArray("lista_balotario");
        JSONArray lista_balotario_bd = new JSONArray();
        JSONObject salida = new JSONObject();

        for (int i = 0; i < lista_balotario_api.length(); i++) {
            JSONObject balotario_api = lista_balotario_api.getJSONObject(i);
            JSONObject balotario_bd = new JSONObject();

            try {
                balotario_api.put("nota", String.valueOf(balotario_api.getInt("nota")));
                balotario_bd = actualizar_balotario_alumno(balotario_api);
            } catch (JSONException ex) {
                balotario_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", balotario_api);
            } catch (PSQLException ex) {
                try {
                    balotario_bd = new JSONObject(ex.getServerErrorMessage().getMessage());
                } catch (JSONException ex2) {
                    balotario_bd
                            .put("status", false)
                            .put("message", ex.getMessage())
                            .put("data", balotario_api);
                }
            } catch (Exception ex) {
                balotario_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", balotario_api);
            }

            lista_balotario_bd.put(balotario_bd);
        }

        return salida
                .put("status", true)
                .put("message", "Éxito")
                .put("data", lista_balotario_bd);
    }

    public JSONObject listar_examen(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("capitulo_id")) {
            params.put(2, entrada.getInt("capitulo_id"));
        }

        if (!entrada.isNull("grado_turno_id")) {
            params.put(3, entrada.getString("grado_turno_id"));
        }

        if (!entrada.isNull("curso_id")) {
            params.put(4, entrada.getInt("curso_id"));
        }

        if (!entrada.isNull("dia")) {
            params.put(5, entrada.getInt("dia"));
        }

        if (!entrada.isNull("estado_id")) {
            params.put(6, entrada.getInt("estado_id"));
        }

        if (!entrada.isNull("enlazado")) {
            params.put(7, entrada.getBoolean("enlazado"));
        }

        if (!entrada.isNull("sede_id")) {
            params.put(8, entrada.getInt("sede_id"));
        }

        if (!entrada.isNull("aula_id")) {
            params.put(9, entrada.getInt("aula_id"));
        }

        entrada.put("params", params);

        return dao.listar_examen(entrada);
    }

    public JSONObject actualizar_examen(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("examen_id")) {
            params.put(2, entrada.getInt("examen_id"));
        }

        if (!entrada.isNull("capitulo_id")) {
            params.put(3, entrada.getInt("capitulo_id"));
        }

        if (!entrada.isNull("url_publicado")) {
            params.put(4, entrada.getString("url_publicado"));
        }

        if (!entrada.isNull("url_edicion")) {
            params.put(5, entrada.getString("url_edicion"));
        }

        if (!entrada.isNull("url_respuesta")) {
            params.put(6, entrada.getString("url_respuesta"));
        }

        if (!entrada.isNull("estado_id")) {
            params.put(7, entrada.getInt("estado_id"));
        }

        if (!entrada.isNull("lista_examen")) {
            params.put(8, entrada.getJSONArray("lista_examen"));
        }

        entrada.put("params", params);

        return dao.actualizar_examen(entrada);
    }

    public JSONObject actualizar_examen_alumno(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        params.put(0, entrada.getString("drive_respuesta"));

        params.put(1, entrada.getString("fecha_registro"));

        params.put(2, entrada.getInt("fila_drive"));

        params.put(3, entrada.getString("correo_alumno"));

        params.put(4, entrada.getString("nota"));

        params.put(5, entrada.getString("apellidos"));

        params.put(6, entrada.getString("nombres"));

        params.put(7, entrada.getString("sede"));

        entrada.put("params", params);

        return dao.actualizar_examen_alumno(entrada);
    }

    public JSONObject actualizar_examen_alumno_masivo(JSONObject entrada) throws Exception {
        JSONArray lista_alumno_api = entrada.getJSONArray("lista_alumno");
        JSONArray lista_alumno_bd = new JSONArray();
        JSONObject salida = new JSONObject();

        for (int i = 0; i < lista_alumno_api.length(); i++) {
            JSONObject alumno_api = lista_alumno_api.getJSONObject(i);
            JSONObject alumno_bd = new JSONObject();

            try {
                alumno_api.put("nota", String.valueOf(alumno_api.getInt("nota")));
                alumno_bd = actualizar_examen_alumno(alumno_api);
            } catch (JSONException ex) {
                alumno_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", alumno_api);
            } catch (PSQLException ex) {
                try {
                    alumno_bd = new JSONObject(ex.getServerErrorMessage().getMessage());
                } catch (JSONException ex2) {
                    alumno_bd
                            .put("status", false)
                            .put("message", ex.getMessage())
                            .put("data", alumno_api);
                }
            } catch (Exception ex) {
                alumno_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", alumno_api);
            }

            lista_alumno_bd.put(alumno_bd);
        }

        return salida
                .put("status", true)
                .put("message", "Éxito")
                .put("data", lista_alumno_bd);
    }

    public JSONObject listar_encuesta(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("encuesta_id")) {
            params.put(2, entrada.getInt("encuesta_id"));
        }

        entrada.put("params", params);

        return dao.listar_encuesta(entrada);
    }

    public JSONObject actualizar_encuesta(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        if (!entrada.isNull("encuesta_id")) {
            params.put(2, entrada.getInt("encuesta_id"));
        }

        entrada.put("params", params);

        return dao.actualizar_encuesta(entrada);
    }

    public JSONObject actualizar_encuesta_alumno(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        params.put(0, entrada.getString("tipo_operacion"));

        params.put(1, entrada.getString("drive_respuesta"));

        params.put(2, entrada.getString("fecha_registro"));

        params.put(3, entrada.getInt("fila_drive"));

        if (!entrada.isNull("correo_institucional")) {
            params.put(4, entrada.getString("correo_institucional"));
        }

        if (!entrada.isNull("sede")) {
            params.put(5, entrada.getString("sede"));
        }

        if (!entrada.isNull("aula")) {
            params.put(6, entrada.getString("aula"));
        }

        if (!entrada.isNull("numero_documento")) {
            params.put(7, entrada.getString("numero_documento"));
        }

        if (!entrada.isNull("nombres")) {
            params.put(8, entrada.getString("nombres"));
        }

        entrada.put("params", params);

        return dao.actualizar_encuesta_alumno(entrada);
    }

    public JSONObject actualizar_encuesta_alumno_masivo(JSONObject entrada) throws Exception {
        JSONArray lista_encuesta_api = entrada.getJSONArray("lista_encuesta");
        JSONArray lista_encuesta_bd = new JSONArray();
        JSONObject salida = new JSONObject();

        for (int i = 0; i < lista_encuesta_api.length(); i++) {
            JSONObject encuesta_api = lista_encuesta_api.getJSONObject(i);
            JSONObject encuesta_bd = new JSONObject();

            try {
                encuesta_bd = actualizar_encuesta_alumno(encuesta_api);
            } catch (JSONException ex) {
                encuesta_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", encuesta_api);
            } catch (PSQLException ex) {
                try {
                    encuesta_bd = new JSONObject(ex.getServerErrorMessage().getMessage());
                } catch (JSONException ex2) {
                    encuesta_bd
                            .put("status", false)
                            .put("message", ex.getMessage())
                            .put("data", encuesta_api);
                }
            } catch (Exception ex) {
                encuesta_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", encuesta_api);
            }

            lista_encuesta_bd.put(encuesta_bd);
        }

        return salida
                .put("status", true)
                .put("message", "Éxito")
                .put("data", lista_encuesta_bd);
    }

    public JSONObject actualizar_aniversario(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("fecha_registro")) {
            params.put(0, entrada.getString("fecha_registro"));
        }

        if (!entrada.isNull("fila_drive")) {
            params.put(1, entrada.getInt("fila_drive"));
        }

        if (!entrada.isNull("tipo_documento")) {
            params.put(2, entrada.getString("tipo_documento"));
        }

        if (!entrada.isNull("numero_documento")) {
            params.put(3, entrada.getString("numero_documento"));
        }

        if (!entrada.isNull("nombres")) {
            params.put(4, entrada.getString("nombres"));
        }

        if (!entrada.isNull("telefono")) {
            params.put(5, entrada.getString("telefono"));
        }

        if (!entrada.isNull("correo")) {
            params.put(6, entrada.getString("correo"));
        }

        if (!entrada.isNull("tipo_venta")) {
            params.put(7, entrada.getString("tipo_venta"));
        }

        if (!entrada.isNull("cantidad_entradas")) {
            params.put(8, entrada.getInt("cantidad_entradas"));
        }

        if (!entrada.isNull("placa")) {
            params.put(9, entrada.getString("placa"));
        }

        if (!entrada.isNull("autorizacion")) {
            params.put(10, entrada.getString("autorizacion"));
        }

        entrada.put("params", params);

        return dao.actualizar_aniversario(entrada);
    }

    public JSONObject actualizar_aniversario_masivo(JSONObject entrada) throws Exception {
        JSONArray lista_aniversario_api = entrada.getJSONArray("lista_aniversario");
        JSONArray lista_aniversario_bd = new JSONArray();
        JSONObject salida = new JSONObject();

        for (int i = 0; i < lista_aniversario_api.length(); i++) {
            JSONObject aniversario_api = lista_aniversario_api.getJSONObject(i);
            JSONObject aniversario_bd = new JSONObject();

            try {
                aniversario_bd = actualizar_aniversario(aniversario_api);
            } catch (JSONException ex) {
                aniversario_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", aniversario_api);
            } catch (PSQLException ex) {
                try {
                    aniversario_bd = new JSONObject(ex.getServerErrorMessage().getMessage());
                } catch (JSONException ex2) {
                    aniversario_bd
                            .put("status", false)
                            .put("message", ex.getMessage())
                            .put("data", aniversario_api);
                }
            } catch (Exception ex) {
                aniversario_bd
                        .put("status", false)
                        .put("message", ex.getMessage())
                        .put("data", aniversario_api);
            }

            lista_aniversario_bd.put(aniversario_bd);
        }

        return salida
                .put("status", true)
                .put("message", "Éxito")
                .put("data", lista_aniversario_bd);
    }

    public JSONObject listar_aniversario_reporte(JSONObject entrada) throws Exception {
        JSONArray params = new JSONArray();

        if (!entrada.isNull("usuario_perfil_id")) {
            params.put(0, entrada.getInt("usuario_perfil_id"));
        }

        params.put(1, entrada.getString("tipo_operacion"));

        entrada.put("params", params);

        return dao.listar_aniversario_reporte(entrada);
    }

    public JSONObject procedureArray(JSONObject json) throws Exception {
        return dao.procedureArray(json);
    }

    public JSONObject procedure (JSONObject json) throws Exception{
        return dao.procedure(json);
    }
    
    public JSONObject informeVacacionalActualizar(JSONObject entrada) throws JSONException, Exception {
        JSONArray params = new JSONArray();
        
        params.put(1, entrada.getString("tipo_operacion"));
        
        if (!entrada.isNull("informe_id")) {
            params.put(2, entrada.getInt("informe_id"));
        }
        
        if (!entrada.isNull("persona_id")) {
            params.put(3, entrada.getInt("persona_id")); 
        }
        
        if (!entrada.isNull("parentesco_id")) {
            params.put(4, entrada.getInt("parentesco_id")); 
        }
        
        if (!entrada.isNull("contacto_telefono")) {
            params.put(5, entrada.getString("contacto_telefono")); 
        }
        
        if (!entrada.isNull("contacto_correo")) {
            params.put(6, entrada.getString("contacto_correo")); 
        }
        
        if (!entrada.isNull("ubigeo_id")) {
            params.put(7, entrada.getInt("ubigeo_id")); 
        }
        
        if (!entrada.isNull("ubigeo_nombre")) {
            params.put(8, entrada.getString("ubigeo_nombre")); 
        }
        
        if (!entrada.isNull("medio_difusion_id")) {
            params.put(9, entrada.getInt("medio_difusion_id")); 
        }
        
        if (!entrada.isNull("medio_atencion_id")) {
            params.put(10, entrada.getInt("medio_atencion_id")); 
        }
        
        if (!entrada.isNull("apertura_id")) {
            params.put(11, entrada.getInt("apertura_id")); 
        }
        
        if (!entrada.isNull("origen_id")) {
            params.put(12, entrada.getInt("origen_id")); 
        }
        
        if (!entrada.isNull("fecha_registro")) {
            params.put(13, entrada.getString("fecha_registro")); 
        }
        
        if (!entrada.isNull("estado_id")) {
            params.put(14, entrada.getInt("estado_id")); 
        }
        
        if (!entrada.isNull("colegio_procedencia_nombre")) {
            params.put(15, entrada.getString("colegio_procedencia_nombre")); 
        }
        
        if (!entrada.isNull("drive_origen")) {
            params.put(16, entrada.getString("drive_origen")); 
        }
        
        if (!entrada.isNull("drive_fila")) {
            params.put(17, entrada.getInt("drive_fila")); 
        }
        
        if (!entrada.isNull("informe_observacion")) {
            params.put(18, entrada.getString("informe_observacion")); 
        }
        
        if (!entrada.isNull("tipo_documento_id")) {
            params.put(19, entrada.getInt("tipo_documento_id")); 
        }
        
        if (!entrada.isNull("numero_documento_identidad")) {
            params.put(20, entrada.getString("numero_documento_identidad")); 
        }

        if (!entrada.isNull("nombres")) {
            params.put(21, entrada.getString("nombres")); 
        }

        if (!entrada.isNull("apellido_paterno")) {
            params.put(22, entrada.getString("apellido_paterno")); 
        }

        if (!entrada.isNull("apellido_materno")) {
            params.put(23, entrada.getString("apellido_materno")); 
        }

        if (!entrada.isNull("sede_id")) {
            params.put(24, entrada.getInt("sede_id")); 
        }
        
         if (!entrada.isNull("sede_nombre")) {
            params.put(25, entrada.getString("sede_nombre")); 
        }
        
        if (!entrada.isNull("grado_nombre")) {
            params.put(26, entrada.getString("grado_nombre")); 
        }
        
        if (!entrada.isNull("matricula_id")) {
            params.put(27, entrada.getInt("matricula_id")); 
        }
        
        return dao.informeVacacionalActualizar(entrada.put("params", params));
    }
     
}