package pe.so.api.formulario.utilities;

import java.io.File;
import java.util.Locale;

public final class OsUtils {
    public enum OSType {
        Windows, MacOS, Linux, Other
    };
    // cached result of OS detection
    private static String detectedOS;
    private static OSType detectedTOS;
    /**
     * detect the operating system from the os.name System property and cache
     * the result
     *
     * @return - the operating system detected
     */
    public static String getOperatingSysstemType() {
        if (detectedOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            if ((OS.contains("mac")) || (OS.contains("darwin"))) {
                detectedOS = "MacOS";
            } else if (OS.contains("win")) {
                detectedOS = "Windows";
            } else if (OS.contains("nux")) {
                detectedOS = "Linux";
            } else {
                detectedOS = "Other";
            }
        }
        return detectedOS;
    }
    public static OSType getOperatingSystemType() {
        if (detectedTOS == null) {
          String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
          if ((OS.contains("mac")) || (OS.contains("darwin"))) {
            detectedTOS = OSType.MacOS;
          } else if (OS.contains("win")) {
            detectedTOS = OSType.Windows;
          } else if (OS.contains("nux")) {
            detectedTOS = OSType.Linux;
          } else {
            detectedTOS = OSType.Other;
          }
        }
        return detectedTOS;
      }
    public static String getDotEnvPathUtil(String projectName) {
        String path = "";
        String detectedOs = OsUtils.getOperatingSysstemType();
        switch (detectedOs) {
            case "MacOS":
            case "Linux":
                path = "/opt/dotenv/"+projectName;
                break;
            case "Windows":
                char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
                for (char letter : alphabet) {
                    path = letter + ":/dotenv/" + projectName;
                    File directory = new File(path);
                    if (directory.exists()) {
                        break;
                    }
                }
                break;
        }
        return path;
    }
    public static String getFilePath(String projectName) {
        String path = "";
        String detectedOs = OsUtils.getOperatingSysstemType();
        switch (detectedOs) {
            case "MacOS":
                path = "";
                break;
            case "Windows":
                char[] alphabet = "abcdefghijklmnopqrstuvwxyz".toCharArray();
                for (char letter : alphabet) {
                    path = letter + ":/AppServ/www/" + projectName+"/";
                    File directory = new File(path);
                    if (directory.exists()) {
                        break;
                    }
                }
                break;
            case "Linux":
                path = "/var/www/html/"+projectName+"/";
                break;
        }
        return path;
    }
}
