package pe.so.api.formulario.postgresdao;

import org.json.JSONArray;
import org.json.JSONObject;
import pe.so.api.formulario.dao.ExcelDAO;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class PostgreSqlExcel implements ExcelDAO{

    @Override
    public JSONObject execute_encuesta(JSONObject json) throws Exception{
        JSONObject respuesta=new JSONObject();
        Connection conexion=null;

        try {

            int p_encuensta_id=json.isNull("p_encuesta_id") ? 0 : json.getInt("p_encuesta_id");
            String p_grupo_encuesta=json.isNull("p_grupo_encuesta") ? "" : json.getString("p_grupo_encuesta");
            String p_correo_alumno=json.isNull("p_correo_alumno") ? "" : json.getString("p_correo_alumno");
            String p_documento = json.isNull("p_documento") ? "" : json.getString("p_documento");
            String p_nombres = json.isNull("p_nombres") ? "" : json.getString("p_nombres");

            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql="select horario.func_encuesta_procesar_alumno(?,?,?,?,?)";
            PreparedStatement ps=conexion.prepareStatement(sql);
            ps.setInt(1,p_encuensta_id);
            ps.setString(2,p_grupo_encuesta);
            ps.setString(3,p_correo_alumno);
            ps.setString(4,p_documento);
            ps.setString(5,p_nombres);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }
            respuesta.put("status",true);

        } catch (Exception e) {
            respuesta.put("status",false);
            respuesta.put("mensaje",e.getMessage());
        } finally {
            if(conexion != null){
                conexion.close();
            }
        }
        return respuesta;
    }

    @Override
    public JSONObject execute_balotario(JSONObject json) throws Exception{
        JSONObject respuesta=new JSONObject();
        Connection conexion=null;

        try {

            String p_drive_respuesta=json.isNull("p_drive_respuesta") ? "" : json.getString("p_drive_respuesta");
            String p_fecha_registro=json.isNull("p_fecha_registro") ? "" : json.getString("p_fecha_registro");
            int p_fila_drive=json.isNull("p_fila_drive") ? 0 : json.getInt("p_fila_drive");
            String p_correo_alumno=json.isNull("p_correo_alumno") ? "" : json.getString("p_correo_alumno");
            String p_nota=json.isNull("p_nota") ? "" : json.getString("p_nota");
            String p_apellidos=json.isNull("p_apellidos") ? "" : json.getString("p_apellidos");
            String p_nombres=json.isNull("p_nombres") ? "" : json.getString("p_nombres");
            String p_sede=json.isNull("p_sede") ? "" : json.getString("p_sede");

            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql="select academico.func_balotario_procesar_alumno(?,?,?,?,?,?,?,?)";
            PreparedStatement ps=conexion.prepareStatement(sql);
            ps.setString(1,p_drive_respuesta);
            ps.setString(2,p_fecha_registro);
            ps.setInt(3,p_fila_drive);
            ps.setString(4,p_correo_alumno);
            ps.setString(5,p_nota);
            ps.setString(6,p_apellidos);
            ps.setString(7,p_nombres);
            ps.setString(8,p_sede);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put("mensaje",rs.getObject(i));
                }
            }
            respuesta.put("status",true);

        } catch (Exception e) {
            respuesta.put("status",false);
            respuesta.put("mensaje",e.getMessage());
        } finally {
            if(conexion != null){
                conexion.close();
            }
        }
        return respuesta;
    }

    public JSONObject ejecutar(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;

        try {

            Date date=new Date();
            java.sql.Timestamp sqlTime=new java.sql.Timestamp(date.getTime());

            String p_drive_origen=json.getString("p_drive_origen");
            int p_drive_fila=json.getInt("p_drive_fila");
            String p_sede=json.getString("p_sede");
            String p_medio_atencion=json.getString("p_medio_atencion");
            String p_contacto_nombres=json.getString("p_contacto_nombres");
            String p_contacto_apellidos=json.getString("p_contacto_apellidos");
            String p_numero_documento=json.getString("p_numero_documento");
            String p_contacto_correo=json.getString("p_contacto_correo");
            String p_atencion_usuario=json.getString("p_atencion_usuario");
            String p_grado=json.getString("p_grado");
            String p_contacto_telefono=json.getString("p_contacto_telefono");
            String p_colegio_procedencia=json.getString("p_colegio_procedencia");
            String p_distrito=json.getString("p_distrito");
            String p_atencion_fecha=json.getString("p_atencion_fecha");
            String p_atencion_estado=json.getString("p_atencion_estado");
            String p_atencion_medio_atencion=json.getString("p_atencion_medio_atencion");
            String p_atencion_hora=json.getString("p_atencion_hora");
            String p_atencion_observacion=json.getString("p_atencion_observacion");
            String p_medio_difusion_nombre=json.getString("p_medio_difusion_nombre");

            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql="select matricula.func_informe_registrar(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            PreparedStatement ps=conexion.prepareStatement(sql);
            ps.setString(1,p_drive_origen);
            ps.setInt(2,p_drive_fila);
            ps.setString(3,sqlTime.toString());
            ps.setString(4,p_sede);
            ps.setString(5,p_medio_atencion);
            ps.setString(6,p_contacto_nombres);
            ps.setString(7,p_contacto_apellidos);
            ps.setString(8,p_numero_documento);
            ps.setString(9,p_contacto_correo);
            ps.setString(10,p_contacto_telefono);
            ps.setString(11,p_distrito);
            ps.setString(12,p_grado);
            ps.setString(13,p_colegio_procedencia);
            ps.setString(14,p_medio_difusion_nombre);
            ps.setString(15,p_atencion_usuario);
            ps.setString(16,p_atencion_fecha);
            ps.setString(17,p_atencion_estado);
            ps.setString(18,p_atencion_medio_atencion);
            ps.setString(19,p_atencion_hora);
            ps.setString(20,p_atencion_observacion);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }

                respuesta.put("status",respuesta.getString("func_informe_registrar").contains("_informe_id"));

            }

        } catch (Exception e) {
            respuesta.put("status",false);
            respuesta.put("mensaje",e.getMessage());
        } finally {
            if(conexion != null){
                conexion.close();
            }
        }
        return respuesta;
    }

    @Override
    public JSONObject execute_avance(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;

        try {

            int p_tipo_operacion=json.getInt("p_tipo_operacion");
            int p_aula_id=json.isNull("p_aula_id") ? 0 : json.getInt("p_aula_id");
            int p_curso_id=json.isNull("p_curso_id") ? 0 : json.getInt("p_curso_id");

            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql="select academico.func_balotario_alumno(?,?,?)";
            PreparedStatement ps=conexion.prepareStatement(sql);
            Statement st=conexion.createStatement();
            ps.setInt(1,p_tipo_operacion);
            ps.setInt(2,p_aula_id);
            ps.setInt(3,p_curso_id);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();

                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),new JSONObject(rs.getObject(i).toString()));
                }
            }

            JSONArray data=respuesta.getJSONObject("func_balotario_alumno").getJSONArray("data");
            JSONArray respuesta2=new JSONArray();
            data.forEach(item -> {
                JSONObject obj=(JSONObject)item;
                String sql2=obj.getString("script");
                try {
                    st.executeQuery(sql2);
                } catch (SQLException ignored) {
                }
            });

            respuesta.put("salida",respuesta2);

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        } finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_redes(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;

        try {
            String p_tipo_vista=json.getString("p_tipo_vista");
            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "SELECT * FROM matricula.func_redes_sociales(?)";

            PreparedStatement ps=conexion.prepareStatement(sql);
            ps.setString(1,p_tipo_vista);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        }finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_VU(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;
        conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try{
            String sql="SELECT * FROM matricula.func_reporte_general_vacacional()";
            ResultSet rs=conexion.prepareStatement(sql).executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        }finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_reporte_sedes(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;
        conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try{
            String sql="select * from matricula.func_reporte_general_matricula()";
            ResultSet rs=conexion.prepareStatement(sql).executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        }finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_reporte_correos(JSONObject json) throws Exception{
        JSONObject respuesta=new JSONObject();
        Connection conexion=null;
        conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try{
            String sql="select * from matricula.func_reporte_general_correos()";
            ResultSet rs=conexion.prepareStatement(sql).executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        }finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    @Override
    public JSONObject execute_avance_encuesta(JSONObject json) throws Exception{

        JSONObject respuesta=new JSONObject();
        Connection conexion=null;
        try {
            int p_opt=json.getInt("p_opt");

            conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql="select academico.func_encuesta_total(?)";
            PreparedStatement ps=conexion.prepareStatement(sql);
            Statement st=conexion.createStatement();
            ps.setInt(1,p_opt);

            ResultSet rs=ps.executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();

                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),new JSONObject(rs.getObject(i).toString()));
                }
            }

            JSONArray data=respuesta.getJSONObject("func_encuesta_total").getJSONArray("data");
            JSONArray respuesta2=new JSONArray();
            data.forEach(item -> {
                JSONObject obj=(JSONObject)item;
                String sql2=obj.getString("script");
                try {
                    st.executeQuery(sql2);
                } catch (SQLException ignored) {
                }
            });

            respuesta.put("salida",respuesta2);

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        } finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }

    public JSONObject execute_reporte_franquicia(JSONObject json) throws Exception{
        JSONObject respuesta=new JSONObject();
        Connection conexion=null;
        conexion=PostgreSqlFactoryDAO.obtenerConexion("siiaa");

        try{
            String sql="select * from matricula.func_reporte_general_franquicia();";
            ResultSet rs=conexion.prepareStatement(sql).executeQuery();

            if(rs.next()){
                int columnCount=rs.getMetaData().getColumnCount();
                for (int i=1; i <= columnCount; i++) {
                    respuesta.put(rs.getMetaData().getColumnName(i),rs.getObject(i));
                }
            }

        } catch (Exception e) {
            respuesta.put("error",e.getMessage());
        }finally {
            if(conexion != null){
                conexion.close();
            }
        }

        return respuesta;
    }
}
