package pe.so.api.formulario.filters;

import org.json.JSONArray;
import org.json.JSONObject;
import pe.so.api.formulario.postgresdao.PostgreSqlTabla;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

@Provider
public class CorsFilter implements Filter{


    @Override
    public void init(FilterConfig filterConfig) throws ServletException{
    }

    @Override
    public void doFilter(ServletRequest servletRequest,ServletResponse servletResponse,FilterChain filterChain) throws IOException, ServletException{

        String[] ExcelIds={"1ItAa2YGBj60AVghmsCfMJZYooDRQGN2gyPWpgtvGHxA",
                            "1puh5xCtsGwwFaqKSgPcRt5II23MtZ2C9u0C_ussVYyc"};

        HttpServletResponse response=(HttpServletResponse)servletResponse;
        HttpServletRequest request=(HttpServletRequest)servletRequest;

        response.setHeader("Access-Control-Allow-Origin","*");
        response.setHeader("Access-Control-Allow-Methods","GET,POST,PUT,DELETE,OPTIONS,HEAD");
        response.setHeader("Access-Control-Max-Age","3600");
        response.setHeader("Access-Control-Allow-Headers","x-requested-with, Content-Type, Authorization");
        response.setHeader("Access-Control-Allow-Credentials","true");

        try {
            if((response.getHeader("Access-Control-Allow-Origin").equals("*") ||
                response.getHeader("Access-Control-Allow-Origin").contains(request.getRemoteHost())) &&
                    (Arrays.asList(ExcelIds).contains(request.getHeader("Authorization")) || existeId(request.getHeader("Authorization")))){

                filterChain.doFilter(servletRequest,response);
            } else {

                response.setContentType("application/json");
                response.setStatus(401);
                response.getWriter().write("{\"mensaje\":\"No estas autorizado a usar este recurso.\",\"status\":false}");
            }
        } catch (SQLException e) {
            throw new RuntimeException(e);
        }

    }

    @Override
    public void destroy(){
    }

    private Boolean existeId(String id) throws SQLException{

        AtomicReference<Boolean> existe=new AtomicReference<>(false);
        JSONArray data=new PostgreSqlTabla().tablaIds(new JSONObject().put("tabla","ac_encuesta_plc")).getJSONArray("data");
        JSONArray data2=new PostgreSqlTabla().tablaIds(new JSONObject().put("tabla","ac_balotario")).getJSONArray("data");

        data.forEach(obj -> {
            JSONObject o=(JSONObject)obj;
            if(o.getString("id").equals(id)){
                existe.set(true);
            }
        });
        data2.forEach(obj -> {
            JSONObject o=(JSONObject)obj;
            if(o.getString("id").equals(id)){
                existe.set(true);
            }
        });

        return existe.get();
    }

}
