package pe.so.api.formulario.dao;

import pe.so.api.formulario.mongodbdao.MongoDBFactoryDAO;
import pe.so.api.formulario.postgresdao.PostgreSqlFactoryDAO;

public abstract class FactoryDAO{
    public static final int MONGODB = 1;
    public static final int POSTGRESQL = 2;

    public static FactoryDAO getFactoryDAO(int whichFactory) {
        switch (whichFactory) {
            case MONGODB:
                return new MongoDBFactoryDAO();
            case POSTGRESQL:
                return new PostgreSqlFactoryDAO();
            default:
                return null;
        }
    }

    public abstract ExcelDAO getExcelDAO();
    public abstract TablasDAO getTablasDAO();


}
