package pe.so.api.formulario.api;

import org.json.JSONObject;
import pe.so.api.formulario.services.ExcelServices;

import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import pe.so.api.formulario.utilities.Commons;

@Provider
@Path("excel")
@Consumes("application/json")
@Produces("application/json")
public class ExcelApi {


    private JSONObject MSJ_RESPUESTA = new JSONObject();

    @POST
    @Path("/encuesta")
    public Response encuesta(String json) throws Exception {

        String[] jsonString = {"p_encuesta_id","p_grupo_encuesta","p_correo_alumno","p_documento","p_nombres"};

        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.execute_encuesta(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }

    @POST
    @Path("/balotario")
    public Response balotario(String json) throws Exception {

        String[] jsonString = {"p_drive_respuesta","p_fila_drive","p_correo_alumno","p_nota","p_apellidos","p_nombres","p_sede","p_fecha_registro"};

        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.execute_balotario(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }


    @POST
    @Path("/ejecutar")
    public Response ejecutar(String json) throws Exception {

         String[] jsonString = {"p_drive_origen", "p_drive_fila", "p_sede", "p_fecha_hora_registro", "p_medio_atencion",
                                "p_contacto_nombres", "p_contacto_apellidos", "p_numero_documento", "p_contacto_correo",
                                "p_contacto_telefono", "p_distrito", "p_grado", "p_colegio_procedencia","p_medio_difusion_nombre",
                                "p_atencion_usuario", "p_atencion_fecha", "p_atencion_estado", "p_atencion_medio_atencion", "p_atencion_hora", "p_atencion_observacion"};


        JSONObject entrada = new JSONObject(json);
        JSONObject formato = Commons.formatoJSON(jsonString);

        if(Commons.validarFormato(jsonString,json)){

            ExcelServices excelServices = new ExcelServices();
            MSJ_RESPUESTA = excelServices.ejecutar(entrada);

            return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
        }else{
            return Response.status(500).entity(
                    MSJ_RESPUESTA.put("status", false)
                            .put("mensaje", "Error en el formato de entrada")
                            .put("formato_esperado", formato).toString()
            ).build();
        }
    }

    @POST
    @Path("/ejecutar_avance")
    public Response ejecutar_avance(String json) throws Exception {
    
        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_avance(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
    
    }

    @POST
        @Path("/ejecutar_redes")
    public Response ejecutar_redes(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_redes(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reportevu")
    public Response ejecutar_reportevu(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_VU(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_sedes")
    public Response ejecutar_reporte_sedes(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_sedes(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_correos")
    public Response ejecutar_reporte_correos(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_correos(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_avance_encuestas")
    public Response ejecutar_avance_encuestas(String json) throws Exception {

        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_avance_encuesta(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();

    }

    @POST
    @Path("/ejecutar_reporte_franquicia")
    public Response ejecutar_reporte_franquicia(String json) throws Exception {
        JSONObject entrada = new JSONObject(json);
        ExcelServices excelServices = new ExcelServices();
        MSJ_RESPUESTA = excelServices.execute_reporte_franquicias(entrada);

        return Response.status(200).entity(MSJ_RESPUESTA.toString()).build();
    }
}
