package pe.so.api.formulario.api;

import pe.so.api.formulario.filters.CorsFilter;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import java.util.*;

@ApplicationPath("api/v1")
public class ApiConfig extends Application {

    private final Set<Object> singletons = new HashSet<>();
    private final HashSet<Class<?>> classes = new HashSet<>();


    public ApiConfig() {

        singletons.add(new CorsFilter());

        classes.add(ExcelApi.class);
        classes.add(TablaApi.class);
    }

    @Override
    public Set<Object> getSingletons() {
        return singletons;
    }

    @Override
    public HashSet<Class<?>> getClasses() {
        return classes;
    }

}
