package pe.so.api.formulario.postgresdao;

import org.json.JSONArray;
import org.json.JSONObject;
import pe.so.api.formulario.dao.TablasDAO;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgreSqlTabla implements TablasDAO{

    @Override
    public JSONObject tablaIds(JSONObject json) throws SQLException{
        JSONArray data = new JSONArray();
        JSONObject respuesta = new JSONObject();
        Connection conexion = null;
        String[] columnas = {};

        if(json.getString("tabla").equals("ac_encuesta_plc")){
            columnas = new String[]{"grupo_encuesta","respuesta_encuesta_drive_id"};

        } else if(json.getString("tabla").equals("ac_balotario")){
            columnas = new String[]{"formulario_titulo","formulario_respuesta_url"};

        } else if(json.getString("tabla").equals("ac_examen")){
            columnas = new String[]{"formulario_titulo","formulario_url_respuesta"};

        }

        try{

            conexion = PostgreSqlFactoryDAO.obtenerConexion("siiaa");

            String sql = "";

            sql = "SELECT * FROM academico."+json.getString("tabla")+"";
            Statement st = conexion.createStatement();
            ResultSet rs = st.executeQuery(sql);

            while(rs.next()){
                JSONObject obj = new JSONObject();
                obj.put("nombre", rs.getString(columnas[0]));
                obj.put("id", rs.getString(columnas[1]));
                data.put(obj);
            }

            respuesta.put("data", data);
            respuesta.put("status", true);
            respuesta.put("mensaje", "OK");


        }catch (Exception e){
            respuesta.put("mensaje", e.getMessage());
            return respuesta;
        }finally {
            if (conexion != null) {
                conexion.close();
            }
        }


        return respuesta;
    }
}
