package salidasautomaticas.services;

import org.json.JSONArray;
import org.json.JSONObject;
import salidasautomaticas.dao.DAOFactory;
import salidasautomaticas.dao.SalidasDAO;

/**
 *
 * @author sistem19user
 */
public class SalidasServices {

    DAOFactory daofactory = DAOFactory.getFactory(DAOFactory.MYSQL);
    SalidasDAO salidadao = daofactory.getSalidasDAO();

    public JSONArray obtenerHorariosSalida() throws Exception {
        JSONArray listaHorarios = null;

        try {
            listaHorarios = salidadao.obtenerHorariosSalida();
        } catch (Exception e) {
            e.printStackTrace();
        }

        return listaHorarios;
    }

    public JSONObject actualizarSalidas(String horaSalida) {
        JSONObject valor = new JSONObject();
        try {
            valor = salidadao.actualizarSalida(horaSalida);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return valor;
    }
    
    public JSONObject asignarHorarioSalida(){
        JSONObject valor = new JSONObject();
        try {
            valor = salidadao.asignarHorarioSalida();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return valor;
    }

}
