/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package salidasautomaticas.mysqldao;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import salidasautomaticas.dao.SalidasDAO;
import salidasautomaticas.util.EstandarDAO;

/**
 *
 * @author sistem19user
 */
public class SalidasMysqlDAO implements SalidasDAO {

    @Override
    public JSONArray obtenerHorariosSalida() throws Exception {
        JSONArray jsonArray = new JSONArray();
        int diaSemana = obtenerDiaSemana();
        if (diaSemana == 7) {
            return jsonArray;
        }

        Connection cn = MysqlDAOFactory.obtenerConexion("nuevo");

        String query = "SELECT {campo_salida} as salida FROM ("
                + "SELECT"
                + "	p.salidaLV, "
                + "	p.salidaS "
                + "FROM"
                + "	asistencia a "
                + "INNER JOIN personal p ON a.codper = p.codper "
                + "INNER JOIN salidas_update su ON p.codcargo = su.codcargo "
                + "WHERE "
                + "	a.fecha_asis=? "
                + "AND p.retirado = 0 "
                + "AND p.horaing = su.horaLV "
                + "AND p.mining = su.minutoLV "
                + "AND p.horaingsabado = su.sabadoLV "
                + "AND p.miningsabado = su.sabadoS "
                + "AND NOT p.codlocal IN ('L035', 'L053', 'L038') "
                + "AND NOT p.pronoe = 1 "
                + "AND NOT p.codcargo IN (71, 13) "
                + "AND NOT p.horaing > 19 "
                + "AND NOT p.salidaS = '') as tabla WHERE NULLIF( {campo_salida} , '') is NOT null  GROUP BY {campo_salida} ";

        if (diaSemana >= 1 && diaSemana <= 5) {
            query = query.replaceAll("\\{campo_salida\\}", "tabla.salidaLV");
        } else if (diaSemana == 6) {
            query = query.replaceAll("\\{campo_salida\\}", "tabla.salidaS");
        }

        JSONArray parametros = new JSONArray();
        parametros.put(getFechaHoy());

        jsonArray = EstandarDAO.getInstance().consultar(cn, query, parametros);

        return jsonArray;
    }

    private int obtenerDiaSemana() {
        int diaSemana;
        LocalDate date = LocalDate.now();
        diaSemana = date.getDayOfWeek().getValue();

        return diaSemana;
    }

    private String getFechaHoy() {
        String fechaHoy;
        LocalDate date = LocalDate.now();
        int anio = date.getYear();
        int mes = date.getMonthValue();
        int dia = date.getDayOfMonth();

        fechaHoy = String.format("%s-%02d-%02d", anio, mes, dia);

        return fechaHoy;
    }

    private String getFechaAyer() {
        String fechaAyer;
        LocalDate date = LocalDate.now();
        date = date.minusDays(1);

        int anio = date.getYear();
        int mes = date.getMonthValue();
        int dia = date.getDayOfMonth();

        fechaAyer = String.format("%s-%02d-%02d", anio, mes, dia);

        return fechaAyer;
    }

    @Override
    public JSONArray obtenerAsistencias(String horaProgramada) throws Exception {
        Connection cn = MysqlDAOFactory.obtenerConexion("nuevo");
        String query = "SELECT * from "
                + "(select "
                + "	asistencia.codasis, "
                + "asistencia.fecha_asis, "
                + "{campo_salida} as salida "
                + "FROM "
                + "	asistencia "
                + "INNER JOIN personal ON asistencia.codper = personal.codper "
                + "WHERE "
                + "	asistencia.horasal = '' "
                + "AND asistencia.minsal = '' "
                + "AND ( {campo_salida} <= ? AND asistencia.fecha_asis='{fecha_hoy}' "//Se setea la horaProgramada como parametro en "?"
                + "OR asistencia.fecha_asis BETWEEN '{fecha_partida}' AND '{fecha_ayer}') "
                + "AND {campo_salida} is not NULL  "
                + "AND NOT personal.codlocal IN ('L035', 'L053', 'L038') "//Que no sea profesores por horas, pronoe belisario, grupo MH
                + "AND NOT personal.codcargo IN (71, 13) "//Que no sea policia ni de cafeteria
                + "AND NOT personal.pronoe = 1 " //Que no sea pronoe
                + "AND (WEEKDAY(asistencia.fecha_asis) + 1) !=7 " //Que no sea domingo
                + "AND NOT ( (WEEKDAY(asistencia.fecha_asis) + 1)=6 and personal.codcargo in ({cod_cargo_primaria})  ) " //Que no sean de primaria los sabados
                + "AND asistencia.estado in (1, 2, 5)"//Que sean asistio, tardanza y no marco
                + "AND personal.retirado=0) as tabla "
                + "where tabla.salida!=''";

        String campoSalida = "("
                + "case "
                + "when (WEEKDAY(asistencia.fecha_asis) + 1)<6 then salidaLV "
                + "when (WEEKDAY(asistencia.fecha_asis) + 1)=6 then salidaS end "
                + ") ";

        String codCargoPrimaria = "1, 2, 4, 9, 11, 12, 20, 25, 33, 39, 40, 45, 51";
        
        String fechaPartida = "2018-04-01";

        query = query.replaceAll("\\{campo_salida\\}", campoSalida);
        query = query.replaceAll("\\{fecha_hoy\\}", getFechaHoy());
        query = query.replaceAll("\\{fecha_partida\\}", fechaPartida);
        query = query.replaceAll("\\{fecha_ayer\\}", getFechaAyer());
        query = query.replaceAll("\\{cod_cargo_primaria\\}", codCargoPrimaria);

        JSONArray parametros = new JSONArray();
        parametros.put(horaProgramada);

        JSONArray jsonArray = EstandarDAO.getInstance().consultar(cn, query, parametros);

        return jsonArray;
    }

    @Override
    public JSONObject actualizarSalida(String horaSalida) throws Exception {
        JSONObject resultado = null;
        Connection cn = MysqlDAOFactory.obtenerConexion("nuevo");

        int aleatorioHora = 0, aleatorioMin = 0;

        JSONArray listaAsistencias = obtenerAsistencias(horaSalida);
        System.out.println("tamaño lista=" + listaAsistencias.length());

        System.out.println("lista de asistencias para actualizar " + horaSalida + " " + listaAsistencias);

        int[] updateCounts = new int[listaAsistencias.length()];
        boolean updateAll = false;

        int i = 0;
        for (Iterator it = listaAsistencias.iterator(); it.hasNext();) {
            JSONObject asistencia = (JSONObject) it.next();

            String salidaPersonal = asistencia.getString("salida");

            if (salidaPersonal == null || salidaPersonal.isEmpty()) {
                updateCounts[i] = -1;
                continue;
            }

            int[] aleatorio = generarHoraMinutoAleatorio(salidaPersonal);
            aleatorioHora = aleatorio[0];
            aleatorioMin = aleatorio[1];

            String queryPersonal = "update asistencia set horasal= ?,minsal=? where codasis=? ";
            JSONArray parametros = new JSONArray();
            parametros
                    .put(aleatorioHora)
                    .put(aleatorioMin)
                    .put(asistencia.getString("codasis"));

            resultado = EstandarDAO.getInstance().ejecutar(cn, queryPersonal, parametros);

            updateCounts[i] = resultado.getInt("msg");
            i++;

            System.out.println("Asistencia actualizada");
        }

        return resultado;
    }

    private int[] generarHoraMinutoAleatorio(String horaMinuto) {
        int[] aleatorio = new int[2];//horaAleatoria index=0, minAleatorio index=1
        String[] splitHoraConsulta = horaMinuto.split(":");
        int min = Integer.parseInt(splitHoraConsulta[1]);
        int hora = Integer.parseInt(splitHoraConsulta[0]);

//        Actualizacion de salidas
        if (min == 0) {
            aleatorio[0] = (int) Math.floor(Math.random() * 2 + (hora - 1));
        } else {
            aleatorio[0] = hora;
        }
        if (hora == aleatorio[0]) {
            if (min == 0) {
                aleatorio[1] = (int) Math.floor(Math.random() * (3 - 0 + 1) + 0);
            } else {
                aleatorio[1] = (int) Math.floor(Math.random() * (33 - 27 + 1) + 27);
            }
        } else {
            aleatorio[1] = (int) Math.floor(Math.random() * 3 + 57);
        }

        return aleatorio;
    }

    @Override
    public JSONObject asignarHorarioSalida() throws Exception {
        Connection cn = MysqlDAOFactory.obtenerConexion("nuevo");
        String query = "update personal p, "
                + "	("
                + "		SELECT 	p.codper, su.salidaLV, su.salidaS FROM personal p INNER JOIN salidas_update su ON p.codcargo=su.codcargo "
                + "	WHERE retirado=0 AND  p.horaing=su.horaLV and  p.mining=su.minutoLV "
                + "	and p.horaingsabado=su.sabadoLV AND p.miningsabado=su.sabadoS and  NOT p.codlocal in('L035','L053','L038') "
                + "	AND NOT pronoe=1 AND not p.codcargo in (71,13) and horaing  < 19 and (nullif(p.salidaLV,'') is null  and nullif(p.salidaS, '') is null) "
                + "	) as tbl "
                + "SET p.salidaLV=tbl.salidaLV, "
                + "		p.salidaS=tbl.salidaS   "
                + "where tbl.codper=p.codper";

        JSONObject resultado = EstandarDAO.getInstance().ejecutar(cn, query);

        return resultado;
    }
    
    public static void main(String[] args) {
        try {
            System.out.println(new SalidasMysqlDAO().actualizarSalida("11:00"));;
        } catch (Exception ex) {
            Logger.getLogger(SalidasMysqlDAO.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

}
