<%
    response.setHeader("Cache-Control", "no-cache"); //Forces caches to obtain a new copy of the page from the origin server
    response.setHeader("Cache-Control", "no-store"); //Directs caches not to store the page under any circumstance
    response.setDateHeader("Expires", 0); //Causes the proxy cache to see the page as "stale"
    response.setHeader("Pragma", "no-cache"); //HTTP 1.0 backward compatibility

    if (session.getAttribute("usuario") != null) {
        response.sendRedirect("main.jsp");
    }
%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Global stylesheets -->
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
    <link href="../plantilla/assets/css/icons/icomoon/styles.css" rel="stylesheet" type="text/css">
    <link href="../plantilla/assets/css/bootstrap.css" rel="stylesheet" type="text/css">
    <link href="../plantilla/assets/css/core.css" rel="stylesheet" type="text/css">
    <link href="../plantilla/assets/css/components.css" rel="stylesheet" type="text/css">
    <link href="../plantilla/assets/css/colors.css" rel="stylesheet" type="text/css">
    <!-- /global stylesheets -->

  </head>

  <body class="login-container">

    <!-- Page container -->
    <div class="page-container">

      <!-- Page content -->
      <div class="page-content">

        <!-- Main content -->
        <div class="content-wrapper">

          <!-- Content area -->
          <div class="content">

            <!-- Advanced login -->
            <form action="#" id="login" >
              <div class="panel panel-body login-form">
                <div class="text-center">
                  <div class="icon-object border-slate-300 text-slate-300"><i class="icon-reading"></i></div>
                  <h5 class="content-group">PROYECTO<small class="display-block">Ingrese sus credenciales</small></h5>
                </div>

                <div class="form-group has-feedback has-feedback-left">
                  <input type="text" id="usuario" name="usuario" class="form-control" placeholder="Usuario" value="blarru">
                  <div class="form-control-feedback">
                    <i class="icon-user text-muted"></i>
                  </div>
                </div>

                <div class="form-group has-feedback has-feedback-left">
                  <input type="password" id="pass" name="pass" class="form-control" placeholder="Contraseña" value="123456">
                  <div class="form-control-feedback">
                    <i class="icon-lock2 text-muted"></i>
                  </div>
                </div>
                
                <div class="form-group">
                  <button type="button" id="signIn" class="btn bg-blue btn-block">Ingresa <i class="icon-arrow-right14 position-right"></i></button>
                </div>
              </div>
            </form>
            <!-- /advanced login -->


            <!-- Footer -->
            <div class="footer text-muted text-center">
              &copy; 2015. <a href="#">Proyecto</a> por <a href="#">Área Sistemas TIC</a>
            </div>
            <!-- /footer -->

          </div>
          <!-- /content area -->

        </div>
        <!-- /main content -->

      </div>
      <!-- /page content -->

    </div>
    <!-- /page container -->
    
    <script>
        ((window) => {
            window.history.replaceState( {} , '', 'index.jsp' );
        })(window);
    </script>
    
    <!--javascript template-->
    <!-- Core JS files -->
    <script type="text/javascript" src="../plantilla/assets/js/plugins/loaders/pace.min.js"></script>
    <script type="text/javascript" src="../plantilla/assets/js/core/libraries/jquery.min.js"></script>
    <script type="text/javascript" src="../plantilla/assets/js/core/libraries/bootstrap.min.js"></script>
    <script type="text/javascript" src="../plantilla/assets/js/plugins/forms/validation/validate.min.js"></script>
    <script type="text/javascript" src="../js/lib/jquery-validation-config.js"></script>
    <script type="text/javascript" src="../plantilla/assets/js/plugins/notifications/sweet_alert.min.js"></script>
    <script type="text/javascript" src="../js/general.js"></script>
    
    <script type="text/javascript" src="../plantilla/assets/js/plugins/loaders/blockui.min.js"></script>
    <!-- /core JS files -->

    <!-- Theme JS files -->
    <script type="text/javascript" src="../plantilla/assets/js/plugins/forms/styling/uniform.min.js"></script>

    <script type="text/javascript" src="../plantilla/assets/js/core/app.js"></script>
    <script type="text/javascript" src="../plantilla/assets/js/pages/login.js"></script>
    <!-- /theme JS files -->
    <!--javascript template-->
    <script src="../js/lib/cookies.js" type="text/javascript"></script>
    <script src="../js/pages/index.js" type="text/javascript"></script>
    
  </body>
</html>

