<%@include file="templates/validar.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
    <head>
        <%@include file="templates/header.jsp" %>
        <!--template-core-->
        <!--css de la pagina-->

        <!--css-->
    </head>
    <body>
        <%@include file="templates/header-body.jsp" %>
        <!--  content -->
        <div class="col-md-6 col-md-offset-3">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h5 class="panel-title">Control de Asistencia de Policias</h5>
                </div>

                <form id="frmAsistenciaPolicias" onsubmit="return false;" autocomplete="off">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label>Busqueda por</label>
                                <select class="form-control" id="cboCriterio">
                                    <option>[SELECCIONE]</option>
                                    <option>SEDE</option>
                                    <option>APELLIDOS</option>
                                    <option>DNI</option>
                                </select>
                            </div>
                            <div class="col-md-8 form-group">
                                <!--                                <label>Busqueda</label>
                                                                <input type="text" class="form-control"/>-->
                                <div id="divCriterio">

                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label>Fecha Inicio</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaInicio" name="dpFechaInicio" placeholder="Fecha inicio &hellip;">
                                </div>

                            </div>
                            <div class="col-md-4 form-group">
                                <label>Fecha Fin</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaFin" name="dpFechaFin" placeholder="Fecha fin &hellip;">
                                </div>

                            </div>

                            <div class="col-md-4 form-group">
                                <label>Estado</label>
                                <select class="selectpicker form-control" name="cboSedes" id="cboEstados" multiple>
<!--                                    <option>PENDIENTE</option>
                                    <option>FCA</option>
                                    <option>FSA</option>
                                    <option>TEMPRANO</option>
                                    <option>TARDANZA</option>
                                    <option>NO MARCÓ</option>-->
                                </select>
                            </div>
                        </div>


                        <div class="row">

                        </div>

                    </div>
                    <div class="panel-footer">
                        <div class="text-center">
                            <button class="btn btn-primary" id="btnBuscar"><i class="fa fa-search"></i> Buscar</button>&nbsp;
                            <button class="btn btn-warning" id="btnLimpiar"><i class="fa fa-eraser"></i> Limpiar</button>
                        </div>
                    </div>

                </form>

            </div>
        </div>


        <div class="col-md-12">
            <div class="panel panel-primary card-3" style="margin-top: 30px"> 
                <div class="panel-heading" style="padding: 8px 15px">
                    <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="icon icon-search4"></i>&nbsp; LISTADO DE ASISTENCIAS</h6>
                </div>
                <div>
                    <table class="table dataTable table-striped table-hover table-sm table-bordered display" id="tblAsistenciaPolicias">                                                 
                        <thead>
                            <tr>
                                <th class="text-center">Nº</th>
                                <th>APELLIDOS Y NOMBRES</th>
                                <th class="text-center">SEDE</th>
                                <th class="text-center">FECHA</th>
                                <th class="text-center">HORARIO</th>
                                <th class="text-center">TIPO</th>
                                <th class="text-center">FRECUENCIA</th>
                                <th class="text-center">MARC. ENTRADA</th>
                                <th class="text-center">MARC. SALIDA</th>
                                <th class="text-center">ESTADO</th>
                                <th class="text-center">ACCIONES</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="text-center">1</td>
                                <td>RAMIREZ MORALES ROLANDO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center">
                                    <span class="text-migration font-weight-bold">06:32</span>
                                </td>
                                <td class="text-center">
                                    <span class="text-default">17:23</span>
                                </td>
                                <td class="text-center"><span class="label label-success">TEMPRANO</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">2</td>
                                <td>RODRIGUEZ CALERO MARCO ANTONIO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">19:00 - 07:00</td>
                                <td class="text-center">AMANECIDA 12H</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center">
                                    <span class="text-migration">19:07</span>
                                </td>
                                <td class="text-center text-migration">07:02</td>
                                <td class="text-center"><span class="label label-warning">TARDANZA</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">3</td>
                                <td>LORENZO CARHUANCHO JOEL</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00- 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">DIARIO</td>
                                <td class="text-center">-</td>
                                <td class="text-center">-</td>
                                <td class="text-center"><span class="label label-danger" title="Falta Con Aviso">FCA</span></td>
                                <td></td>

                            </tr>
                            <tr>
                                <td class="text-center">4</td>
                                <td>VASQUEZ PEREZ LIDER</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00- 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">PAR</td>
                                <td class="text-center">-</td>
                                <td class="text-center">-</td>
                                <td class="text-center"><span class="label label-danger" title="Falta Sin Aviso">FSA</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">5</td>
                                <td>SILVA ASTUDILLO VICTOR SEGUNDO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 07:00</td>
                                <td class="text-center">AMANECIDA 24H</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center">07:24</td>
                                <td class="text-center text-migration">06:58</td>
                                <td class="text-center"><span class="label label-default">NO MARCÓ</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">6</td>
                                <td>PACHECO PANCA ADOLFO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 07:00</td>
                                <td class="text-center">AMANECIDA 24H</td>
                                <td class="text-center">PAR</td>
                                <td class="text-center">-</td>
                                <td class="text-center">-</td>
                                <td class="text-center"><span class="label label-info" title="Vacaciones">VAC</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">7</td>
                                <td>GONZALES MARCHISIO JUAN CARLOS</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 17:00</td>
                                <td class="text-center">AMANECIDA 24H</td>
                                <td class="text-center">DIARIO</td>
                                <td class="text-center">-</td>
                                <td class="text-center">-</td>
                                <td class="text-center"><span class="label label-info" title="Feriado">FER</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">8</td>
                                <td>SOTO GUTIERREZ MANUEL JESUS</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:50 - 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">UN SOLO DÍA</td>
                                <td class="text-center">-</td>
                                <td class="text-center">-</td>
                                <td class="text-center"><span class="label label-info" title="Licencia con goce de haberes">LCGH</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="text-center">9</td>
                                <td>VIDAL AVILA WILLY CESAR</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center"></td>
                                <td class="text-center">17:13</td>
                                <td class="text-center"><span class="label bg-purple">ENTRADA PENDIENTE</span></td>
                                <td class="text-center">
                                    <span data-toggle="modal" data-target="#modal_entrada_pendiente" data-placement="left" title="Editar" style="cursor: pointer"> <i class='registrar icon-plus-circle2 text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='editar icon-pencil text-slate-800'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Aprobar" style="cursor: pointer"> <i class='aprobar icon-checkmark-circle text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Anular" style="cursor: pointer"> <i class='anular icon-cancel-circle2 text-danger-700'></i>&nbsp;&nbsp; </span>


                                </td>
                            </tr>
                            <tr>
                                <td class="text-center">10</td>
                                <td>PAREDES HUANUQUEÑO ROBERTO SANTOS</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 17:00</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center text-migration">07:28</td>
                                <td></td>
                                <td class="text-center"><span class="label bg-purple">SALIDA PENDIENTE</span></td>
                                <td class="text-center">
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='registrar icon-plus-circle2 text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='editar icon-pencil text-slate-800'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Aprobar" style="cursor: pointer"> <i class='aprobar icon-checkmark-circle text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Anular" style="cursor: pointer"> <i class='anular icon-cancel-circle2 text-danger-700'></i>&nbsp;&nbsp; </span>


                                </td>
                            </tr>
                            <tr>
                                <td class="text-center">11</td>
                                <td>PICHIGUA MELENDEZ ANTONIO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:50 - 14:30</td>
                                <td class="text-center">REGULAR</td>
                                <td class="text-center">DIARIO</td>
                                <td class="text-center"></td>
                                <td></td>
                                <td class="text-center"><span class="label bg-purple">PENDIENTE</span></td>
                                <td class="text-center">
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='registrar icon-plus-circle2 text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='editar icon-pencil text-slate-800'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Aprobar" style="cursor: pointer"> <i class='aprobar icon-checkmark-circle text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Anular" style="cursor: pointer"> <i class='anular icon-cancel-circle2 text-danger-700'></i>&nbsp;&nbsp; </span>


                                </td>
                            </tr>
                            <tr>
                                <td class="text-center">12</td>
                                <td>ALCALDE VENTURA JORGE EMILIANO</td>
                                <td class="text-center">VILLA EL SALVADOR</td>
                                <td class="text-center">26/06/2018</td>
                                <td class="text-center">07:00 - 07:00</td>
                                <td class="text-center">AMANECIDA 24H</td>
                                <td class="text-center">IMPAR</td>
                                <td class="text-center" style="color: #999999;"><strong>07:24</strong></td>
                                <td class="text-center" style="color: #999999;"><strong>06:58</strong></td>
                                <td class="text-center"><span class="label label-default">NO MARCÓ x2</span></td>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>





        <div id="modal_entrada_pendiente" class="modal fade">
            <div class="modal-dialog modal-sm">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <h5 class="modal-title">Registrar Asistencia</h5>
                    </div>

                    <div class="modal-body">
                        <div>
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <label>Fecha de asistencia</label>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                        <input class="datepicker form-control" type="text" id="txtFechaAsistencia" value="26/06/2018" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="form-group col-md-12">
                                    <label>Policia</label>
                                    <span class="label label-left border-left-primary label-striped form-control">DEZA CORREA OSCAR MIGUEL</span>
                                </div>
                            </div>


                            <div class="row">
                                <div class="form-group col-md-12">
                                    <label style="font-size: small">
                                        Tipo de registro:
                                    </label>
                                    <span class="text-danger"> (*)</span>
                                    <select id="cboTipoAsistencia" class="form-control">
                                        <option value="0">[SELECCIONE]</option>
                                        <option value="1">Registro Autorizado</option>
                                        <option value="3">Falta con Aviso</option>
                                        <option value="4">Falta sin Aviso</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row" id="divFiltro">

                            </div>

                        </div>

                    </div>

                    <div class="modal-footer text-center">
                        <button class="btn btn-success" id="btnGuardarCambios" data-dismiss="modal"><i class="fa fa-search"></i> Guardar Cambios</button>&nbsp;
                        <button type="button" class="btn btn-warning" id="btnCancelar" data-dismiss="modal"><i class="fa fa-eraser"></i> Cancelar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- / content -->

        <%@include file="templates/footer-body.jsp"%>
        <!--js de la pagina-->


        <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap.min.js"></script>
        <script src="../js/lib/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
        <script type="text/javascript" src="../plantilla/assets/js/plugins/pickers/daterangepicker.js"></script>
        <script type="text/javascript" src="../plantilla/assets/js/core/libraries/jquery_ui/widgets.min.js"></script>
        <script src="../js/lib/axios.min.js" type="text/javascript"></script>
        <script src="../js/pages/control_asistencia_policias.js" type="text/javascript"></script>
        <!--js-->   
    </body>
</html>