<%@include file="templates/validar.jsp" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
    <head>
        <%@include file="templates/header.jsp" %>
        <!--template-core-->
        <!--css de la pagina-->
        <!--<link href="../css/lib/bootstrap-select/bootstrap-select.min.css" rel="stylesheet" type="text/css"/>-->
        <!--css-->
    </head>
    <body>
        <%@include file="templates/header-body.jsp" %>
        <!--  content -->

        <div class="col-md-6 col-md-offset-3">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h5 class="panel-title">Control de Asistencia de Docentes</h5>
                </div>

                <form id="frmAsistenciaDocentes" onsubmit="return false;" autocomplete="off">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-3 form-group">
                                <label>Busqueda por</label>
                                <select class="form-control" id="cboCriterio">
                                    <option>SEDE</option>
                                    <option>APELLIDOS</option>
                                    <option>DNI</option>
                                </select>
                            </div>
                            <div class="col-md-9 form-group">
                                <!--                                <label>Busqueda</label>
                                                                <input type="text" class="form-control"/>-->
                                <div id="divCriterio"><label>Sede</label>
                                    <select class="form-control" id="cboSedes">
                                        <option>LINCE</option>
                                        <option>AREQUIPA</option>
                                        <option>LINCE</option>
                                        <option>MONTESORI</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 form-group">
                                <label>Fecha Inicio</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaInicio" name="dpFechaInicio" placeholder="Fecha inicio &hellip;">
                                </div>

                            </div>
                            <div class="col-md-6 form-group">
                                <label>Fecha Fin</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaFin" name="dpFechaFin" placeholder="Fecha fin &hellip;">
                                </div>

                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-10 form-group">
                                <label>Estado</label>
                                <select class="selectpicker form-control" name="cboSedes" id="cboSedes" multiple>
                                    <option>PENDIENTE</option>
                                    <option>FCA</option>
                                    <option>FSA</option>
                                    <option>TEMPRANO</option>
                                    <option>TARDANZA</option>
                                    <option>NO MARCÓ</option>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="panel-footer">
                        <div class="text-center">
                            <button class="btn btn-primary" id="btnBuscar"><i class="fa fa-search"></i> Buscar</button>&nbsp;
                            <button class="btn btn-warning" id="btnLimpiar"><i class="fa fa-eraser"></i> Limpiar</button>
                        </div>
                    </div>

                </form>

            </div>
        </div>


        <div class="col-md-10 col-md-offset-1">
            <div class="panel panel-primary card-3" style="margin-top: 30px"> 
                <div class="panel-heading" style="padding: 8px 15px">
                    <h6 class="panel-title" style="font-size: 15px; font-family: inherit"><i class="icon icon-search4"></i>&nbsp; LISTADO DE ASISTENCIAS</h6>
                </div>
                <div>
                    <table class="table dataTable table-striped table-hover table-sm table-bordered" id="tblAsistenciaDocentes">                                                 
                        <thead>
                            <tr>
                                <th>Nº</th>
                                <!--<th>SEDE</th>-->
                                <th>APELLIDOS Y NOMBRES</th>
                                <th>FECHA</th>
                                <th>HORARIO</th>
                                <th>HORA MARCACIÓN</th>
                                <th>AULAS</th>
                                <th>ESTADO</th>
                                <th>ACCIONES</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>1</td>
                                <td>HUAMANI TAIPE, FRANCISCO</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">07:35</td>
                                <td>1A-2A-3A-4A</td>
                                <td><span class="label label-success">TEMPRANO</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>2</td>
                                <td>LEON GOMEZ, MARIO JOSIMAR</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 09:35</td>
                                <td class="text-center">07:56</td>
                                <td>1A</td>
                                <td><span class="label label-warning">TARDANZA</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>3</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">-</td>
                                <td>1A</td>
                                <td><span class="label label-danger">FCA</span></td>
                                <td><img title="Reemplazo" src="../img/icons/replace_teacher.png" width="24" height="24" alt=""/></td>

                            </tr>
                            <tr>
                                <td>3</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">-</td>
                                <td>1A</td>
                                <td><span class="label label-danger">FSA</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">07:24</td>
                                <td>1A</td>
                                <td><span class="label label-default">NO MARCÓ</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">-</td>
                                <td>1A</td>
                                <td><span class="label label-info">VAC</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">-</td>
                                <td>1A</td>
                                <td><span class="label label-info">FER</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center">-</td>
                                <td>1A</td>
                                <td><span class="label label-info">LCGH</span></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td>4</td>
                                <td>ALVITES MARIN, VICTOR MANUEL</td>
                                <td>26/06/2018</td>
                                <td>07:50 - 14:30</td>
                                <td class="text-center"></td>
                                <td>1A</td>
                                <td><span class="label bg-purple">PENDIENTE</span></td>
                                <td>
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='registrar icon-plus-circle2 text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Editar" style="cursor: pointer"> <i class='editar icon-pencil text-slate-800'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Aprobar" style="cursor: pointer"> <i class='aprobar icon-checkmark-circle text-success-700'></i>&nbsp;&nbsp; </span>
                                    <span data-toggle="tooltip" data-placement="left" title="Anular" style="cursor: pointer"> <i class='anular icon-cancel-circle2 text-danger-700'></i>&nbsp;&nbsp; </span>


                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>






        <!-- Basic modal -->
        <div id="modal_default" class="modal fade">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-primary">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h5 class="modal-title">Basic modal</h5>
                    </div>

                    <div class="modal-body">
                        <h6 class="text-semibold">Text in a modal</h6>
                        <p>Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p>

                        <hr>

                        <h6 class="text-semibold">Another paragraph</h6>
                        <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.</p>
                        <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-link" data-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary">Save changes</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- /basic modal -->

        <!-- / content -->

        <%@include file="templates/footer-body.jsp"%>
        <!--js de la pagina-->
        <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap.min.js"></script>
        <script src="../js/lib/bootstrap-select/bootstrap-select.min.js" type="text/javascript"></script>
        <script type="text/javascript" src="../plantilla/assets/js/plugins/pickers/daterangepicker.js"></script>
        <script type="text/javascript" src="../plantilla/assets/js/core/libraries/jquery_ui/widgets.min.js"></script>
        <script src="../js/pages/controlAsistenciaDocentes.js" type="text/javascript"></script>
        <!--js-->   
    </body>
</html>