let data = [];
let sedes = [];
let handsonTable;
function initializeData() {
    data.push({"dni": "12345678", "nombres": "DELGADO CHOZO JUAN FRANCISCO", "sede": "CANTA CALLAO 2", "horario": "07:00 - 17:00", "tipo_horario": "REGULAR",
        "fecha_entrada": "15/06/2018", "marcacion_entrada": "06:59", "marcacion_salida": "00:00", "fecha_salida": "15/06/2018"});
    data.push({"dni": "12345678", "nombres": "DELGADO CHOZO JUAN FRANCISCO", "sede": "CANTA CALLAO 2", "horario": "07:00 - 17:00", "tipo_horario": "REGULAR",
        "fecha_entrada": "16/06/2018", "marcacion_entrada": "06:59", "marcacion_salida": "00:00", "fecha_salida": "16/06/2018"});
    data.push({"dni": "12345678", "nombres": "DELGADO CHOZO JUAN FRANCISCO", "sede": "CANTA CALLAO 2", "horario": "07:00 - 07:00", "tipo_horario": "AMANECIDA 24h",
        "fecha_entrada": "17/06/2018", "marcacion_entrada": "06:59", "marcacion_salida": "00:00", "fecha_salida": "18/06/2018"});


    sedes = ["LINCE", "MONTESORI", "AREQUIPA", "ARENALES", "CUBA", "COCALENOS", "BELISARIO", "BERTONELLI", "VILLA EL SALVADOR"];
}



function defaultConfigHandsonTable() {
    let container = document.getElementById("tblProyectado");

    handsonTable = new Handsontable(container, {
        data: [],
        stretchH: 'all',
        rowHeaders: true,
        colHeaders: ['DNI', 'Apellidos y Nombres', 'Sede', 'Horario', 'Rol', 'Fecha Entrada', 'Hora entrada', 'Hora Salida', 'Fecha Salida'],
        columns: [{}, {}, {}, {}, {}, {}, {}, {}, {}]
    });
}



function mostrarVistaPrevia() {
    handsonTable.destroy();
    let container = document.getElementById("tblProyectado");
    handsonTable = new Handsontable(container, {
        data: data,
        stretchH: 'all',
        rowHeaders: true,
        colHeaders: ['DNI', 'Apellidos y Nombres', 'Sede', 'Horario', 'Rol', 'Fecha Entrada', 'Hora entrada', 'Hora Salida', 'Fecha Salida'],
        columns: [
            {
                data: "dni",
                className: 'text-center',
                readOnly: true
            },
            {
                "data": "nombres",
                readOnly: true
            },
            {
                "data": "sede",
                "className": "text-center",
//                editor: 'select',
//                selectOptions: sedes,
                source: sedes,
                strict: true,
                type: 'autocomplete',
                allowInvalid: false
            },
            {
                "data": "horario",
                "className": "text-center",
                readOnly: true
            },
            {
                "data": "tipo_horario",
                "className": "text-center",
                readOnly: true
            },
            {
                "data": "fecha_entrada",
                "className": 'text-center',
                type: 'date',
                dateFormat: 'DD/MM/YYYY',
                readOnly: true

            },
            {
                data: "marcacion_entrada",
                className: 'text-center',
                editor: TA_EDITOR_HORA,
                type: 'time',
                timeFormat: 'HH:mm',
                correctFormat: true,
                allowInvalid: false
            },
            {
                data: "marcacion_salida",
                className: 'text-center',
                timeFormat: 'HH:mm',
                editor: TA_EDITOR_HORA,
                type: 'time',
                correctFormat: true,
                allowInvalid: false,
            },
            {
                data: "fecha_salida",
                className: 'text-center',
                type: 'date',
                dateFormat: 'DD/MM/YYYY',
                readOnly: true
            }
        ]
    });

    registrarEventoTab();
}

function registrarEventoTab() {
    Handsontable.Dom.addEvent(document.body, 'keydown', function (e) {
        if (e.keyCode === 9 && handsonTable) {


            e.stopPropagation();
            var selection = handsonTable.getSelected();

            var rowIndex = selection[0];
            var colIndex = selection[1];

            console.log(`row=${rowIndex}, col=${colIndex}`)

            //rowIndex++;
            colIndex++;


            if (colIndex > 7) {
                rowIndex++;
                colIndex = 6;
            } else if (colIndex < 6) {
                colIndex = 6;
            }

            handsonTable.selectCell(rowIndex, colIndex);
        }
    });
}




// This example creates a date editor that will show MM/YYYY
const TA_EDITOR_HORA = Handsontable.editors.TextEditor.prototype.extend();

TA_EDITOR_HORA.prototype.createElements = function () {
    Handsontable.editors.TextEditor.prototype.createElements.apply(this, arguments);

    // You need to require/import the "inputmask" library
    var im = new Inputmask('99:99');

    // Create password input and update relevant properties
    this.TEXTAREA = document.createElement('input');
    this.TEXTAREA.setAttribute('type', 'text');
    this.TEXTAREA.className = 'text';
    im.mask(this.TEXTAREA);
    this.textareaStyle = this.TEXTAREA.style;
    this.textareaStyle.width = 0;
    this.textareaStyle.height = 0;

    // Replace textarea with password input
    Handsontable.dom.empty(this.TEXTAREA_PARENT);
    this.TEXTAREA_PARENT.appendChild(this.TEXTAREA);

};





$(function () {
    $("#dpFechaInicio").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaInicio").datepicker('setDate', 'now');
    $("#dpFechaFin").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaFin").datepicker('setDate', 'now');
//    defaultConfigDataTable();
    defaultConfigHandsonTable();
    initializeData();
    $("#btnVistaPrevia").click(mostrarVistaPrevia);
});