/*Envio de datos al servidor*/
const httpRequest = {
    login(params) {
        return ajaxRequestSendBody({
            url: '../login',
            type: 'POST',
            headers: {
                "Accept": 'application/json'
            },
            body: params
        })
    }
}

// domevents
const DOMEvents = {
    init() {
        this.signIn()
    },
    signIn() {

        document.querySelector('#signIn').addEventListener('click', (e) => {
            let validator = $('#login').validate({
                rules: {
                    usuario: {required: true},
                    pass: {required: true}
                },
                messages: {
                    usuario: {
                        required: 'completar el campo usuario.'
                    },
                    pass: {
                        required: 'ingresar contraseña.'
                    }
                }
            })
            let estado = validator.form()
            if (estado) {
                block()
                let params = {
                    usuario: document.querySelector('#usuario').value.trim(),
                    pass: document.querySelector('#pass').value,
                    codigoProyecto: CODIGO_PROYECTO_ASISTENCIA
                }
                httpRequest.login(params)
                        .then(data => {
                            $.unblockUI();
                            console.log(data)
                            if(data.status){
                                window.location.href="../vistas/main.jsp";
                            }else{
                                customSwal.alert('¡Error!', "Usuario o contraseña incorrecto.", 'error')
                            }
                        })
                        .catch(err => console.log(err))
            }
        })
    }

}


DOMEvents.init()