function init() {
    listarTipoRoles();
    listarFrecuenciaRol();
    listarSedes();
    listarPolicias();
    listarRolesPolicias();
}

function listarRolesPolicias() {
    axios.get(URI_ROL_POLICIA).then((result) => {
        let columns = [
            {
                title: `N°`,
//                data: `numeroFila`
                data: `id`
            },
            {
                title: `APELLIDOS Y NOMBRES`,
                data: `policia_nombres`
            },
            {
                title: `SEDE`,
                data: `sede_descripcion`
            },
            {
                title: `FECHA INICIO`,
                data: `fecha_inicio`
            },
            {
                title: `FECHA FIN`,
                data: `fecha_fin`
            },
            {
                title: `TIPO`,
                data: `tiporol_descripcion`
            },
            {
                title: `FRECUENCIA`,
                data: `frecuencia_descripcion`
            },
            {
                title: `ESTADO`,
                data: `estado`,
                render: (data) => {
                    let label;
                    
                    if(Object.is(data, 1)){
                        return `<span class="label label-success">ACTIVO</span>`;
                    }else{
                        return `<span class="label label-danger">INACTIVO</span>`;
                    }
                }
            },
        ];

        let columnDefs = [
            {orderable: false, width: '5%', targets: 0, className: "text-center"},
            {orderable: false, width: '5%', targets: 1},
            {orderable: false, width: '30%', targets: 2, className: "text-center"},
            {orderable: false, width: '7%', targets: 3, className: "text-center"},
            {orderable: false, width: '7%', targets: 4, className: "text-center"},
            {orderable: false, width: '10%', targets: 5, className: "text-center"},
            {orderable: false, width: '8%', targets: 6, className: "text-center"},
            {orderable: false, width: '8%', targets: 7, className: "text-center"}
        ];

        let wrapsNameDatatable = `divRoles`;
        let classNameForDatatable = `display table table-bordered`;
        let footer = false

        makeDatatable({
            data: result.data,
            columns: columns,
            columnDefs: columnDefs,
            wrapsNameDatatable: wrapsNameDatatable,
            classNameForDatatable: classNameForDatatable,
            footer: footer
        });

    });
}

function listarTipoRoles() {
    axios.get(URI_TIPOROL_POLICIA).then((result) => {
        let roles = result.data;
        let html = "<option>[SELECCIONE]</option>";
        roles.forEach(rol => html += `<option value="${rol.codigo}">${rol.descripcion}</option>`);
        $("#cboTipoRol").html(html);
    });
}


function listarFrecuenciaRol() {
    axios.get(URI_FRECUENCIA_ROL_POLICIA).then((result) => {
        let frecuenciasRol = result.data;
        let html = "<option>[SELECCIONE]</option>";
        frecuenciasRol.forEach(f => html += `<option value="${f.codigo}">${f.descripcion}</option>`);
        $("#cboFrecuenciaRol").html(html);
    });
}

function listarSedes() {
    axios.get(URI_SEDES).then((result) => {
        let sedes = result.data;
        sedes = _.orderBy(sedes, s => s.descripcion);
        let html = "<option>[SELECCIONE]</option>";
        sedes.forEach(sede => html += `<option value="${sede.codigo}">${sede.descripcion}</option>`);
        $("#cboSedes").html(html);
    });
}

function listarPolicias() {
    axios.get(URI_POLICIAS).then((result) => {
        let policias = result.data;
        policias = _.orderBy(policias, p => p.nombres);
        let html = "<option>[SELECCIONE]</option>";
        policias.forEach(p => html += `<option value="${p.id}">${p.nombres}</option>`);
        $("#cboPolicias").html(html);
    });
}


function modificarServicio() {
//    debugger
    $("#detalle_rol").addClass("hidden");
    $("#editar_rol").removeClass("hidden");
    $("#modal-title").html('Cambiar servicio');
    $("#modal-header").removeClass('bg-primary');
    $("#modal-header").addClass('bg-jade');
    $("#botones-editar").removeClass('hidden');
    $("#btnCerrar").addClass("hidden");

    animar();
//    e.preventDefault();
}

function registrarRolPolicia() {
    let policia_nombres = $("#cboPolicias option:selected").text();
    let policia_id = $("#cboPolicias").val();
    let tiporol_id = $("#cboTipoRol").val();
    let tiporol_descripcion = $("#cboTipoRol option:selected").text();
    ;
    let rango_fechas = $("#dpRangoFechas").val();
    let split_fechas = rango_fechas.split("-").map(f => f.trim());
    let fecha_inicio = split_fechas[0];
    let fecha_fin = split_fechas[1];
    let frecuencia_id = $("#cboFrecuenciaRol").val();
    let frecuencia_descripcion = $("#cboFrecuenciaRol option:selected").text();
    let sede_id = $("#cboSedes").val();
    let sede_descripcion = $("#cboSedes option:selected").text();
    let estado = 1;

    let params = {
        policia_id,
        policia_nombres,
        sede_id,
        sede_descripcion,
        fecha_inicio,
        fecha_fin,
        tiporol_id,
        tiporol_descripcion,
        frecuencia_id,
        frecuencia_descripcion,
        estado
    };

    debugger;

    axios.post(URI_ROL_POLICIA, params)
            .then( (result) => {
                debugger
                
                listarRolesPolicias();
                console.log(result.data);
            })
            .catch(error => {
                console.log(error);
            });
}

function cancelar() {
    $("#detalle_rol").removeClass("hidden");
    $("#editar_rol").addClass("hidden");
    $("#modal-title").html('Ver detalle rol');
    $("#modal-header").addClass('bg-primary');
    $("#modal-header").removeClass('bg-jade');
    $("#botones-editar").addClass('hidden');
    $("#btnCerrar").removeClass("hidden");
    animar();
}

function animar() {
    let animation = `fadeIn`;

    $("#modal_body_tombo2").addClass(`animated ${animation}`).one("webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend", function () {
        $(this).removeClass(`animated ${animation}`);
    });
}


function guardarCambios() {
    cancelar();
    $("#servicio13").css("background-color", "lightpink");
}



$().ready(function () {
    init();
    defaultConfigDataTable();
    $('.selectpicker').selectpicker({
        style: 'btn-info',
        size: 4
    });


    $('.select-search').select2();


    $(".btn.dropdown-toggle.bs-placeholder").removeClass("btn-info");
    $(".btn.dropdown-toggle.bs-placeholder").css({
        border: "1px solid #ddd",
        backgroundColor: "#fff"
    });

    $("#dpFechaInicio").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaInicio").datepicker('setDate', 'now');

    $("#dpFechaFin").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaFin").datepicker('setDate', 'now');

    defaultConfigDatePicker();
    defaultConfigDateRangePicker();
    $('#servicio13').click(modificarServicio);
    $("#btnCancelar").click(cancelar);
    $("#btnGuardarCambios").click(guardarCambios);
    $("#btnRegistrar").click(registrarRolPolicia);
});