let asistencias = [], sedes = [];
let htmlSedes;

function init() {
    listarEstadoAsistencia();
}


function listarSedes() {

    if (Object.is(htmlSedes, undefined)) {
        axios.get(URI_LISTAR_SEDES).then((result) => {
            debugger
            let sedes = result.data;
            htmlSedes = `<label>Sede</label>
            <select class="selectpicker form-control" name="busqueda" id="busqueda" multiple>`;
            sedes.forEach((s) => {
                htmlSedes += `<option value="${s.codigo}">${s.descripcion}</option>`;
            });
            htmlSedes += `</select>`;
            debugger
            $('#divCriterio').html(htmlSedes);
            $('.selectpicker').selectpicker({
                style: 'btn-info',
                size: 4
            });

            $(".btn.dropdown-toggle.bs-placeholder").removeClass("btn-info");
            $(".btn.dropdown-toggle.bs-placeholder").css({
                border: "1px solid #ddd",
                backgroundColor: "#fff"
            });

        }).catch((error) => {
            console.log(error);
        });
    } else {
        $('#divCriterio').html(htmlSedes);
        $('.selectpicker').selectpicker({
            style: 'btn-info',
            size: 4
        });
        $(".btn.dropdown-toggle.bs-placeholder").removeClass("btn-info");
        $(".btn.dropdown-toggle.bs-placeholder").css({
            border: "1px solid #ddd",
            backgroundColor: "#fff"
        });
    }

}


function listarEstadoAsistencia() {
    axios.get(URI_LISTAR_ESTADO_ASISTENCIA).then((result) => {
        let estados = result.data;
        let html = "";
        estados.forEach(e => {
            html += `<option value="${e.codigo}">${e.nombre}</option>`;
        });
        $("#cboEstados").html(html);
        $("#cboEstados").selectpicker('refresh');
        $('.selectpicker').selectpicker({
            style: 'btn-info',
            size: 4
        });
        $(".btn.dropdown-toggle.bs-placeholder").removeClass("btn-info");
        $(".btn.dropdown-toggle.bs-placeholder").css({
            border: "1px solid #ddd",
            backgroundColor: "#fff"
        });
        debugger;
    });
}



function buscar() {
    let criterio = $("#cboCriterio").val();
    let busqueda = $("#busqueda");
    let fechaInicio = $("#dpFechaInicio").val();
    let fechaFin = $("#dpFechaFin").val();
    let estadoAsistencia = $("#cboEstados");

    $("#tblAsistenciaPolicias").DataTable().destroy();
    $("#tblAsistenciaPolicias").DataTable({
        iDisplayLength: 5,
        bStateSave: false,
        autoWidth: false,
        responsive: true,
        stateSave: true,
        columnDefs: [{
                orderable: false,
                width: '100px',
                targets: [8]
            }],
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        "processing": true,
        "serverSide": false,
        "data": asistencias,
        "columns": [{"data": "fila"},
            {"data": "nombres"},
            {"data": "dni"},
            // {"data": "sede"},
            {"data": "area"},
            {"data": "cargo"},
            {
                "data": "fecha_asistencia",
                "className": 'text-center'
            },
            {
                "data": "hora_ingreso",
                "className": 'text-center'
            },
            {
                "data": "hora_salida",
                "className": 'text-center'
            },
            {
                "data": "observacion",
                "className": 'text-center',
                render: function (data) {
                    let label = '';
                    let obs = ['', 'AsistiÃ³', 'No marcó', 'Falta con aviso', 'Falta sin aviso', 'Tardanza', 'Vacaciones', 'Feriado', 'LSGH', 'LCGH'];
                    debugger
                    switch (data) {
                        case "1"://AsistiÃ³
                            label = "label label-success";
                            break;
                        case "2"://No marco
                            label = 'label label-info';
                            break;
                        case "3"://'Falta con aviso'
                        case "4"://'Falta sin aviso'
                            label = 'label label-danger';
                            break;
                        case "5"://'Tardanza'
                            label = 'label label-warning';
                            break;
                        case "6"://'Vacaciones'
                        case "7"://'Feriado'
                        case "8"://'LSGH'
                        case "9"://'LCGH'
                            label = 'label label-primary';
                            break;
                        default:
                            label = 'label label-default';
                    }

                    debugger
                    console.log(label);

                    return `<span class="${label}" style="font-size: 12px">${obs[data]}</span>`;
                }
            }
        ],
        fnInitComplete: function (settings, data) {
            console.log(data);
        }
    });

}


//$("#dp").datepicker({
//    minDate: new Date(1900, 1 - 1, 1), maxDate: '-18Y',
//    dateFormat: 'dd/mm/yy',
//    defaultDate: new Date(1970, 1 - 1, 1),
//    changeMonth: true,
//    changeYear: true,
//    yearRange: '-110:-18',
//    onSelect: function () {
//        $(this).valid();
//    }
//});



//$("#dtpFechaInicio").datepicker('setDate', 'now');


function seleccionCriterio() {
    $("#cboCriterio").change(function () {
        let criterio = $(this).val();
        console.log(criterio);
        debugger;

        if (criterio === 'SEDE') {
            listarSedes();
            // debugger
        } else if (criterio == 'APELLIDOS') {
            let html = `<label id="lblCriterio">Apellidos</label>
      <input type="text" class="form-control" id="busqueda" maxlength="50">`;
            $('#divCriterio').html(html);
            $('#busqueda').validCampo('abcdefghijklmnopqrstuvwxyzñABCDEFGHIJKLMNOPQRSTUVWXYZÑ ');
        } else if (criterio == 'DNI') {
            let html = `<label id="lblCriterio">DNI</label>
    <div class="input-group" style="width:100%">
      <input type="text" class="form-control" id="busqueda" maxlength="8">
    </div>`;
            $('#divCriterio').html(html);
            $('#busqueda').validCampo('0123456789');
        } else {
            $('#divCriterio').html('');
        }


    });
}



function evtChange() {
    let criterio = $(this).val();
    console.log(criterio);
    if (criterio == 0) {
        let html = ``;
        $("#divFiltro").html(html);
    }
    if (criterio == 1 || criterio == 2) {
        let html =
                `<div class=''>
                        
                        <div class="form-group col-md-12">
                            <label style="font-size: small">Tipo de registro:</label>
                            <span class="text-danger"> (*)</span>
                            <select id="cboTipoRegistro" class="form-control">
                                        <option value="0">[SELECCIONE]</option>
                                        <option value="1">NO MARCÓ</option>
                                        <option value="2">HUELLA DESCONOCIDA</option>
                                        <option value="3">OTROS</option>
                            </select>
                        </div>
                        
                        <div class="form-group col-md-6">                                            
                           <label style="font-size: small">
                               Marcación: 
                           </label>
                           <span class="text-danger"> (*)</span>
                           <select id="cboTipoAsistencia" class="form-control">
                                        <option value="0">[SELECCIONE]</option>
                                        <option value="1">ENTRADA</option>
                                        <option value="2">SALIDA</option>
                            </select>                                            
                       </div>
                       <div class="form-group col-md-6">                                            
                           <label style="font-size: small">
                               Hora: 
                           </label>
                           <span class="text-danger"> (*)</span>
                           <input type="time" id="txtHora" name="txtHora" value="" class="form-control" placeholder="Ingrese la hora" style="text-transform:uppercase;">                                            
                       </div> 
                    </div>`;
        $("#divFiltro").html(html);
    } else if (criterio == 3 || criterio == 4) {
        let html =
                `<div class='col-md-12'>
                       <div class="form-group">                                            
                           <label style="font-size: small">
                               Observación: 
                           </label>
                           <span class="text-danger"> (*)</span>
                           <textarea type="text" id="txtObservacion" name="txtObservacion" value="" class="form-control" placeholder="Ingrese el motivo de la falta" rows="3" style="resize: none;"/>                                            
                       </div> 
                   </div>`;
        $("#divFiltro").html(html);
    }
}







$().ready(function () {
    init();
    defaultConfigDataTable();
    $('.selectpicker').selectpicker({
        style: 'btn-info',
        size: 4
    });


    $(".btn.dropdown-toggle.bs-placeholder").removeClass("btn-info");
    $(".btn.dropdown-toggle.bs-placeholder").css({
        border: "1px solid #ddd",
        backgroundColor: "#fff"
    });

    $("#dpFechaInicio").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(2018, 6, 31),
        dateFormat: 'dd/mm/yy',
//        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaInicio").datepicker('setDate', 'now');

    $("#dpFechaFin").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(2018, 6, 31),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaFin").datepicker('setDate', 'now');

    $("#cboTipoAsistencia").change(evtChange);


    defaultConfigDatePicker();

    seleccionCriterio();

});


