const URI_LISTAR_PROYECTADO_COMPARATIVO = "";
function initilizeData() {

}


function seleccionarCriterio() {
    let criterio = $(this).val();
    if (criterio === "PERIODO") {
        let html = `<div class="col-md-8 form-group">
                        <label>Periodo</label>
                        <select id="cboPeriodo" class="form-control">
                            <option>JUNIO 2018 - 1° QUINCENA</option>
                            <option>JUNIO 2018 - 2° QUINCENA</option>
                            <option>JULIO 2018 - 1° QUINCENA</option>
                            <option>AGOSTO 2018 - 2° QUINCENA</option>
                        </select>
                    </div>`;
        $("#divCriterio").html(html);
    } else if (criterio === "FECHA") {
        let html = `<div class="col-md-4 form-group">
                                <label>Fecha Inicio</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaInicio" name="dpFechaInicio" placeholder="Fecha inicio &hellip;">
                                </div>

                            </div>
                            <div class="col-md-4 form-group">
                                <label>Fecha Fin</label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                    <input type="text" class="form-control" id="dpFechaFin" name="dpFechaFin" placeholder="Fecha fin &hellip;">
                                </div>
                            </div>`;
        $("#divCriterio").html(html);
        initDatePicker();
    } else {
        $("#divCriterio").html('');
    }

}

function buscar() {
//    let datos = [];
//    let criterioPersonal = $("#cboCriterioPersonal").val();
//    if (criterioPersonal === "dni" || criterioPersonal === "nombres") {
//        let busquedaPersonal = $("#txtBusquedaPersonal").val();
//        datos = _.filter(data, p => p[criterioPersonal].toLowerCase().startsWith(busquedaPersonal.toLowerCase()));
//        debugger;
//    } else {
//        datos = data;
//    }
//    let numero = 1;
//    datos.forEach(p => p["numeroFila"] = numero++);
    $("#tblProyectadoComparativo").DataTable().destroy();
    $("#tblProyectadoComparativo").DataTable({
        "language": {
            "lengthMenu": "Mostrar: _MENU_",
            "zeroRecords": "&nbsp;&nbsp;&nbsp; No se encontraron resultados",
            "info": "&nbsp;&nbsp;&nbsp; Mostrando del _START_ al _END_ de un total de _TOTAL_ registros",
            "infoEmpty": "&nbsp;&nbsp;&nbsp; Mostrando 0 de 0 registros",
            "search": "Filtrar:",
            "loadingRecords": "Cargando...",
            "processing": '<span style="width:100%;"><img src="http://www.snacklocal.com/images/ajaxload.gif"></span>',
            "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        },
        "bSort": false,
        "bFilter": false,
        "aaSorting": [],
        "ordering": false,
        "bLengthChange": false,
        "bInfo": true,
        "paging": true,
        iDisplayLength: 20,
        bStateSave: false,
        autoWidth: false,
        responsive: true,
        stateSave: true,
        columnDefs: [
            {orderable: false, width: '5%', targets: 0, className: "text-center"},
            {orderable: false, width: '5%', targets: 1},
            {orderable: false, width: '30%', targets: 2, className: "text-center"},
            {orderable: false, width: '7%', targets: 3, className: "text-center"},
            {orderable: false, width: '7%', targets: 4, className: "text-center"},
            {orderable: false, width: '10%', targets: 5, className: "text-center"},
            {orderable: false, width: '8%', targets: 6, className: "text-center"},
            {orderable: false, width: '8%', targets: 7, className: "text-center"},
            {orderable: false, width: '8%', targets: 8, className: "text-center"},
            {orderable: false, width: '8%', targets: 9, className: "text-center"},
            {orderable: false, width: '8%', targets: 10, className: "text-center"},
            {orderable: false, width: '8%', targets: 11, className: "text-center"},
            {orderable: false, width: '8%', targets: 12, className: "text-center"},
            {orderable: false, width: '8%', targets: 13, className: "text-center"},
            {orderable: false, width: '8%', targets: 14, className: "text-center"}
        ],
        dom: '<"datatable-header"fl><"datatable-scroll-wrap"t><"datatable-footer"ip>',
        "processing": true,
        ajax: {
            contentType: 'application/json; charset=utf-8',
            url: URI_LISTAR_PROYECTADO_COMPARATIVO,
//            data: {
//                busqueda: busqueda
//            }
//            , 
            beforeSend: function () {
//                cargando();

            }, complete: function () {
//                localStorage.removeItem("dniBuscar");
//                dniBuscar=null;
//                cerrar_cargando();
            }
        },
        columns: [
            {data: "numeroFila", className: "text-center"},
            {data: "dni"},
            {data: "nombres"},
            {
                data: "turno",
                render: data => {
                    let label;
                    switch (data) {
                        case "REGULAR":
                            label = "label label-primary";
                            break;
                        case "AMANECIDA 24H":
                            label = "label label-success border-success-700";
                            break;
                        case "AMANECIDA 12H":
                            label = "label label-warning border-warning-700";
                            break;
                        default:
                            label = "label label-default";
                    }
                    return `<span class="${label}">${data}</span>`;
                }
            },
            {data: "sede", className: "text-center", render: sede => `<span class="label bg-brown-400 border-brown-700">${sede}</span>`},
            {data: "costo", className: "text-center", render: costo => parseFloat(costo).toFixed(2)},
            {data: "fecha_entrada", className: "text-center"},
            {data: "entrada_proyectada", className: "text-center"},
            {
                data: "marcacion_entrada",
                className: "text-center",
                render: data => {
                    let label;
                    console.log(data);
                    if (data === "0:00") {
                        data = "NO MARCÓ";
                        label = "text-danger";
                    }
                    return `<span class="${label}">${data}</span>`;
                }
            },
//        {data: "diferencia_entrada", className: "text-center"},
            {data: "fecha_salida", className: "text-center"},
            {data: "salida_proyectada", className: "text-center"},
            {
                data: "marcacion_salida",
                className: 'text-center',
                render: data => {
                    let label;
                    console.log(data);
                    if (data === "0:00") {
                        data = "NO MARCÓ";
                        label = "text-danger";
                    }
                    return `<span class="${label}">${data}</span>`;
                }
            },
//        {data: "diferencia_salida", className: 'text-center'},
            {data: "diferencia_total", className: 'text-center', render: data => `${data} min`},
            {
                data: "monto",
                className: 'text-center',
                render: monto => {
                    let label;
                    if (monto > 0) {
                        label = "text-sucess";
                    } else if (monto < 0) {
                        label = "text-danger";
                    } else {
                        label = "";
                    }

                    let numeroReal = parseFloat(monto).toFixed(2);
                    return `<label class="${label}">${numeroReal}</label>`;
                }
            },
            {data: "observacion", className: 'text-center'},
        ],
        fnInitComplete: function (settings, data) {
            $('th').removeClass('sorting_asc');
//            console.log(data);
        }
    });
}



function initDatePicker() {
    $("#dpFechaInicio").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaInicio").datepicker('setDate', 'now');
    $("#dpFechaFin").datepicker({
        minDate: new Date(2000, 1 - 1, 1), maxDate: new Date(),
        dateFormat: 'dd/mm/yy',
        defaultDate: new Date(),
        changeMonth: true,
        changeYear: true,
        yearRange: '-18:+0',
        onSelect: function () {
//        $(this).valid();
        }
    });
    $("#dpFechaFin").datepicker('setDate', 'now');
}

function pintarCriterioPersonal() {
    let criterio = $(this).val();
    if (criterio === "dni") {
        let html = `<div class="col-md-8 form-group">
                        <label>DNI</label>
                        <input type="text" class="form-control" id="txtBusquedaPersonal"></input>
                    </div>`;
        $("#divCriterioPersonal").html(html);
    } else if (criterio === "nombres") {
        let html = `<div class="col-md-8 form-group">
                        <label>Apellidos</label>
                        <input type="text" class="form-control" id="txtBusquedaPersonal"></input>
                    </div>`;
        $("#divCriterioPersonal").html(html);
        initDatePicker();
    } else {
        $("#divCriterioPersonal").html('');
    }
}


$().ready(function () {
    initilizeData();
    defaultConfigDatePicker();
    $("#cboCriterio").change(seleccionarCriterio);
    $("#btnBuscar").click(buscar);
    $("#cboCriterioPersonal").change(pintarCriterioPersonal);
});