/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package asistencia.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

/**
 *
 * @author Percy Oliver Quispe Huarcaya
 */
public final class HttpRequest {

    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PUT = "PUT";

    private URL getConn(String path) {
        URL url = null;
        try {
            url = new URL(path);
        } catch (MalformedURLException ex) {
            System.out.println("Error :  HttpRequest : " + ex.getMessage());
        }
        return url;
    }

    private HttpURLConnection setDefaultValues(URL url, String requestMethod, String authorization) throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection) url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Authorization", authorization);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod(requestMethod);
        return conn;
    }

    /*Ruta para la solicitud HTTTP , Verbo HTTP (Get,Post,Put,...),Objeto json para enviar al servidor destino*/
    public String getRespuesta(String path, String requestMethod, JSONObject obj,String authorization) throws IOException {
        StringBuilder respuesta = new StringBuilder();
        URL url = getConn(path);
        HttpURLConnection conn = setDefaultValues(url, requestMethod,authorization);
        OutputStream os = conn.getOutputStream();
        os.write(obj.toString().getBytes());
        os.close();
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String linea;
        //procesamos al salida
        while ((linea = rd.readLine()) != null) {
            respuesta.append(linea);
        }   
        rd.close();
        conn.disconnect();
        return respuesta.toString();
    }
}
