/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package asistencia.servlets;

import asistencia.utilities.ExcelHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PoliciasServlet extends HttpServlet {

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String accion = request.getParameter("accion");

        switch (accion) {
            case "exportarMontos":
                exportarMontos(request, response);
            break;
            default:
                response.getWriter().print("Especifique un parametro");
        }

    }

    public void exportarMontos(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException{
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=sample.xls");
        OutputStream output = response.getOutputStream();
        ExcelHelper excel = new ExcelHelper(output);
        String[] headers = {"id", "nombres", "apellidos", "edad"};
        Object[][] data = new Object[][]{
            new Object[]{"1", "Felipe", "Escala", "22"},
            new Object[]{"2", "Luis", "Gangas", "23"},};

        excel.setHeaders(headers);
        excel.setSheetName("Pruebas");
        excel.setData(data);
        excel.generate();
    }
}
