/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package asistencia.servlets;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/**
 *
 * @author sistem19user
 */
public class CrearExcel {

    public static void main(String args[]) {
        //Crear libro de trabajo en blanco
        Workbook workbook = new HSSFWorkbook();
        //Crea hoja nueva
        Sheet sheet = workbook.createSheet("Reporte de montos");

        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFillForegroundColor(IndexedColors.AQUA.getIndex());
        headerStyle.setFillPattern(CellStyle.SOLID_FOREGROUND);

        String[] headers = {"Identificador", "Nombre", "Apellidos"};

        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(header);
        }
        
        
        Object[][] data = new Object[][]{
          new Object[]{1, "María", "Remen"},  
          new Object[]{2, "David", "Allos"},  
          new Object[]{3, "Carlos", "Caritas"}  
        };
        
        int i = 0;
        for(String header: headers){
            Cell cell = headerRow.createCell(i++);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(header);
        }
        
        i = 1;
        Row row;
        for(Object[] array: data){
            row = sheet.createRow(i++);
            
            Cell cell;
            int j = 0;
            for(Object value: array){
                cell = row.createCell(j++);
                
                if(value instanceof Integer){
                    cell.setCellValue(Integer.parseInt(value.toString()));
                }else if(value instanceof String){
                    cell.setCellValue(value.toString());
                }else if(value instanceof Double){
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }else if(value instanceof Boolean){
                    cell.setCellValue((boolean)value);
                }else{
                    cell.setCellValue(value.toString());
                }
            }
        }
        
        sheet.createFreezePane(0, 1);

        try {
            //Se genera el documento
            FileOutputStream out = new FileOutputStream(new File("D:/ejemplo.xls"));
            workbook.write(out);
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
